/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import ai.djl.mxnet.jna.ObjectPool;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.nio.charset.Charset;

final class NativeString {
    private static final ObjectPool<NativeString> POOL = new ObjectPool(null, null);
    private Memory pointer;

    private NativeString(byte[] data) {
        this.pointer = new Memory((long)(data.length + 1));
        this.setData(data);
    }

    private void setData(byte[] data) {
        this.pointer.write(0L, data, 0, data.length);
        this.pointer.setByte((long)data.length, (byte)0);
    }

    public static NativeString of(String string, Charset encoding) {
        byte[] data = string.getBytes(encoding);
        NativeString array = POOL.acquire();
        if (array != null && array.pointer.size() > (long)data.length) {
            array.setData(data);
            return array;
        }
        return new NativeString(data);
    }

    public void recycle() {
        POOL.recycle(this);
    }

    public Pointer getPointer() {
        return this.pointer;
    }
}

