/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.buffer;

import org.bytedeco.javacpp.Pointer;
import org.tensorflow.internal.buffer.ByteSequenceTensorBuffer;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.RawDataBufferFactory;

class TensorRawDataBufferFactory
extends RawDataBufferFactory {
    TensorRawDataBufferFactory() {
    }

    static ByteDataBuffer mapTensorToBytes(Pointer tensorMemory, boolean readOnly) {
        return TensorRawDataBufferFactory.mapNativeBytes(tensorMemory.address(), tensorMemory.capacity(), readOnly);
    }

    static IntDataBuffer mapTensorToInts(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeInts(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static LongDataBuffer mapTensorToLongs(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeLongs(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static FloatDataBuffer mapTensorToFloats(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeFloats(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static DoubleDataBuffer mapTensorToDoubles(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeDoubles(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static ShortDataBuffer mapTensorToShorts(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeShorts(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static BooleanDataBuffer mapTensorToBooleans(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeBooleans(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static ByteSequenceTensorBuffer mapTensorToStrings(Pointer tensorMemory, long numElements) {
        return new ByteSequenceTensorBuffer(tensorMemory, numElements);
    }
}

