/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.index;

import java.util.StringJoiner;
import org.tensorflow.ndarray.impl.dimension.Dimension;
import org.tensorflow.ndarray.index.Index;

final class Hyperslab
implements Index {
    private final long start;
    private final long stride;
    private final long count;
    private final long block;

    @Override
    public long numElements(Dimension dimension) {
        return this.count * this.block;
    }

    @Override
    public long mapCoordinate(long coordinate, Dimension dimension) {
        return this.start + this.stride * (coordinate / this.block) + coordinate % this.block;
    }

    @Override
    public Dimension apply(Dimension dim) {
        return dim.withIndex(this);
    }

    @Override
    public boolean isPoint() {
        return false;
    }

    Hyperslab(long start, long stride, long count, long block) {
        this.start = start;
        this.stride = stride;
        this.count = count;
        this.block = block;
    }

    public String toString() {
        return new StringJoiner(", ", Hyperslab.class.getSimpleName() + "Hyperslab(", ")").add("start=" + this.start).add("stride=" + this.stride).add("count=" + this.count).add("block=" + this.block).toString();
    }

    @Override
    public boolean isStridedSlicingCompliant() {
        return false;
    }
}

