/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;

@OpMetadata(opType="LoadTPUEmbeddingMDLAdagradLightParameters", inputsClass=Inputs.class)
public final class LoadTPUEmbeddingMDLAdagradLightParameters
extends RawOp {
    public static final String OP_NAME = "LoadTPUEmbeddingMDLAdagradLightParameters";

    public LoadTPUEmbeddingMDLAdagradLightParameters(Operation operation) {
        super(operation, OP_NAME);
    }

    public static LoadTPUEmbeddingMDLAdagradLightParameters create(Scope scope, Operand<TFloat32> parameters, Operand<TFloat32> accumulators, Operand<TFloat32> weights, Operand<TFloat32> benefits, Long numShards, Long shardId, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(parameters.asOutput());
        opBuilder.addInput(accumulators.asOutput());
        opBuilder.addInput(weights.asOutput());
        opBuilder.addInput(benefits.asOutput());
        opBuilder.setAttr("num_shards", numShards);
        opBuilder.setAttr("shard_id", shardId);
        if (options != null) {
            for (Options opts : options) {
                if (opts.tableId != null) {
                    opBuilder.setAttr("table_id", opts.tableId);
                }
                if (opts.tableName != null) {
                    opBuilder.setAttr("table_name", opts.tableName);
                }
                if (opts.config == null) continue;
                opBuilder.setAttr("config", opts.config);
            }
        }
        return new LoadTPUEmbeddingMDLAdagradLightParameters(opBuilder.build());
    }

    public static Options tableId(Long tableId) {
        return new Options().tableId(tableId);
    }

    public static Options tableName(String tableName) {
        return new Options().tableName(tableName);
    }

    public static Options config(String config) {
        return new Options().config(config);
    }

    @OpInputsMetadata(outputsClass=LoadTPUEmbeddingMDLAdagradLightParameters.class)
    public static class Inputs
    extends RawOpInputs<LoadTPUEmbeddingMDLAdagradLightParameters> {
        public final Operand<TFloat32> parameters;
        public final Operand<TFloat32> accumulators;
        public final Operand<TFloat32> weights;
        public final Operand<TFloat32> benefits;
        public final long tableId;
        public final String tableName;
        public final long numShards;
        public final long shardId;
        public final String config;

        public Inputs(GraphOperation op) {
            super(new LoadTPUEmbeddingMDLAdagradLightParameters(op), op, Arrays.asList("table_id", "table_name", "num_shards", "shard_id", "config"));
            int inputIndex = 0;
            this.parameters = op.input(inputIndex++);
            this.accumulators = op.input(inputIndex++);
            this.weights = op.input(inputIndex++);
            this.benefits = op.input(inputIndex++);
            this.tableId = op.attributes().getAttrInt("table_id");
            this.tableName = op.attributes().getAttrString("table_name");
            this.numShards = op.attributes().getAttrInt("num_shards");
            this.shardId = op.attributes().getAttrInt("shard_id");
            this.config = op.attributes().getAttrString("config");
        }
    }

    public static class Options {
        private Long tableId;
        private String tableName;
        private String config;

        private Options() {
        }

        public Options tableId(Long tableId) {
            this.tableId = tableId;
            return this;
        }

        public Options tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Options config(String config) {
            this.config = config;
            return this;
        }
    }
}

