/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.replication;

import com.kingbase8.util.TraceLogger;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public final class LogSequenceNumber
implements Comparable<LogSequenceNumber> {
    public static final LogSequenceNumber INVALID_LSN = LogSequenceNumber.valueOf(0L);
    private final long _value;

    private LogSequenceNumber(long _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._value = _value;
    }

    public static LogSequenceNumber valueOf(long _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new LogSequenceNumber(_value);
    }

    public static LogSequenceNumber valueOf(String strVal) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int slashIndex = strVal.lastIndexOf(47);
        if (slashIndex <= 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return INVALID_LSN;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String logicalXLogStr = strVal.substring(0, slashIndex);
        int logicalXlog = (int)Long.parseLong(logicalXLogStr, 16);
        String segmentStr = strVal.substring(slashIndex + 1, strVal.length());
        int segment = (int)Long.parseLong(segmentStr, 16);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteBuffer _buf = ByteBuffer.allocate(8);
        _buf.putInt(logicalXlog);
        _buf.putInt(segment);
        _buf.position(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long _value = _buf.getLong();
        return LogSequenceNumber.valueOf(_value);
    }

    public long asLong() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._value;
    }

    public String asString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteBuffer _buf = ByteBuffer.allocate(8);
        _buf.putLong(this._value);
        _buf.position(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int logicalXlog = _buf.getInt();
        int segment = _buf.getInt();
        return String.format("%X/%X", logicalXlog, segment);
    }

    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (int)(this._value ^ this._value >>> 32);
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "LSN{" + this.asString() + '}';
    }

    @Override
    public int compareTo(LogSequenceNumber obj) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._value == obj._value) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._value + Long.MIN_VALUE < obj._value + Long.MIN_VALUE ? -1 : 1;
    }

    public boolean equals(Object object) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        if (this == object) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            v = true;
            return v;
        }
        if (object == null || this.getClass() != object.getClass()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            v = false;
            return v;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LogSequenceNumber thatSeq = (LogSequenceNumber)object;
        return this._value == thatSeq._value;
    }
}

