/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.mybatis.plus;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.core.support.container.query.AbstractQueryContainerProvider;
import cn.crane4j.core.support.container.query.NamespaceResolvableQueryContainerProvider;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ReflectUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MybatisPlusQueryContainerProvider
extends NamespaceResolvableQueryContainerProvider<BaseMapper<?>> {
    private @Nullable Function<String, BaseMapper<?>> mapperFactory;
    protected final Crane4jGlobalConfiguration crane4jGlobalConfiguration;

    public MybatisPlusQueryContainerProvider(MethodInvokerContainerCreator methodInvokerContainerCreator, Crane4jGlobalConfiguration globalConfiguration) {
        this(methodInvokerContainerCreator, globalConfiguration, null);
    }

    public MybatisPlusQueryContainerProvider(MethodInvokerContainerCreator methodInvokerContainerCreator, Crane4jGlobalConfiguration globalConfiguration, @Nullable Function<String, BaseMapper<?>> mapperFactory) {
        super(methodInvokerContainerCreator);
        this.crane4jGlobalConfiguration = globalConfiguration;
        this.mapperFactory = mapperFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> Container<K> getQueryContainer(String name, @Nullable String keyProperty, @Nullable List<String> properties) {
        if (!this.registeredRepositories.containsKey(name) && Objects.nonNull(this.mapperFactory)) {
            Map map = this.registeredRepositories;
            synchronized (map) {
                if (!this.registeredRepositories.containsKey(name)) {
                    this.registerRepository(name, this.mapperFactory.apply(name));
                }
            }
        }
        return super.getQueryContainer(name, keyProperty, properties);
    }

    protected AbstractQueryContainerProvider.Repository<BaseMapper<?>> createRepository(String name, BaseMapper<?> target) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)name);
        if (Objects.isNull(tableInfo)) {
            tableInfo = Optional.ofNullable(Proxy.getInvocationHandler(target)).map(h -> (Class)ReflectUtils.getFieldValue((Object)h, (String)"mapperInterface")).map(this::extractModelClass).map(TableInfoHelper::getTableInfo).orElseThrow(() -> new Crane4jException("cannot resolve bean type of mapper [{}]", new Object[]{name}));
        }
        return new MapperInfo(tableInfo, target);
    }

    protected @NonNull MethodInvoker createMethodInvoker(String namespace, AbstractQueryContainerProvider.Repository<BaseMapper<?>> repository, Set<String> queryColumns, String keyColumn, String keyProperty) {
        return new Query((BaseMapper)repository.getTarget(), queryColumns.toArray(new String[0]), keyColumn);
    }

    protected Class<?> extractModelClass(Class<?> mapperClass) {
        return Arrays.stream(mapperClass.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).flatMap(type -> Arrays.stream(type.getActualTypeArguments())).filter(Class.class::isInstance).map(Class.class::cast).filter(modelClass -> !Object.class.equals(modelClass)).findFirst().orElse(null);
    }

    public void setMapperFactory(@Nullable Function<String, BaseMapper<?>> mapperFactory) {
        this.mapperFactory = mapperFactory;
    }

    protected static class Query<T>
    implements MethodInvoker {
        private final BaseMapper<T> baseMapper;
        private final String[] queryColumns;
        private final String key;

        public Object invoke(Object target, Object ... args) {
            Collection keys = CollectionUtils.adaptObjectToCollection((Object)args[0]);
            return this.baseMapper.selectList(this.getQueryWrapper(keys));
        }

        private QueryWrapper<T> getQueryWrapper(Collection<?> keys) {
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query().in((Object)this.key, keys);
            if (this.queryColumns.length > 0) {
                wrapper.select(this.queryColumns);
            }
            return wrapper;
        }

        public Query(BaseMapper<T> baseMapper, String[] queryColumns, String key) {
            this.baseMapper = baseMapper;
            this.queryColumns = queryColumns;
            this.key = key;
        }
    }

    protected static class MapperInfo
    implements AbstractQueryContainerProvider.Repository<BaseMapper<?>> {
        private final TableInfo tableInfo;
        private final BaseMapper<?> baseMapper;
        private final Map<String, String> columnMap;
        private final Map<String, String> queryColumnMap;

        public MapperInfo(TableInfo tableInfo, BaseMapper<?> baseMapper) {
            this.tableInfo = tableInfo;
            this.baseMapper = baseMapper;
            this.columnMap = tableInfo.getFieldList().stream().collect(Collectors.toMap(TableFieldInfo::getProperty, TableFieldInfo::getColumn));
            this.columnMap.put(tableInfo.getKeyProperty(), tableInfo.getKeyColumn());
            this.queryColumnMap = tableInfo.getFieldList().stream().collect(Collectors.toMap(TableFieldInfo::getProperty, TableFieldInfo::getSqlSelect));
            this.queryColumnMap.put(tableInfo.getKeyProperty(), tableInfo.getKeySqlSelect());
        }

        public BaseMapper<?> getTarget() {
            return this.baseMapper;
        }

        public String getTableName() {
            return this.tableInfo.getTableName();
        }

        public Class<?> getEntityType() {
            return this.tableInfo.getEntityType();
        }

        public String getKeyProperty() {
            return this.tableInfo.getKeyProperty();
        }

        public String propertyToColumn(String property, String defaultValue) {
            return this.columnMap.getOrDefault(property, defaultValue);
        }

        public String propertyToQueryColumn(String property, String defaultValue) {
            return this.queryColumnMap.getOrDefault(property, defaultValue);
        }
    }
}

