/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.container.ContainerMethodAnnotationProcessor;
import cn.crane4j.core.support.container.MethodContainerFactory;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.Order;

@Order
public class BeanMethodContainerRegistrar
extends ContainerMethodAnnotationProcessor
implements BeanPostProcessor,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(BeanMethodContainerRegistrar.class);
    private final Crane4jGlobalConfiguration configuration;

    public BeanMethodContainerRegistrar(Collection<MethodContainerFactory> factories, AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration) {
        super(factories, annotationFinder);
        this.configuration = configuration;
    }

    public void destroy() {
        this.nonAnnotatedClasses.clear();
    }

    public Object postProcessBeforeInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        Class beanType = AopUtils.getTargetClass((Object)bean);
        Collection containers = this.process(bean, beanType);
        log.debug("process [{}] annotated methods for bean [{}]", (Object)containers.size(), (Object)beanName);
        containers.forEach(arg_0 -> ((Crane4jGlobalConfiguration)this.configuration).registerContainer(arg_0));
        return bean;
    }
}

