/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDefinition;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.DefaultContainerManager;
import cn.crane4j.core.container.lifecycle.ContainerLifecycleProcessor;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.ConfigurationUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;

public class Crane4jApplicationContext
extends DefaultContainerManager
implements Crane4jGlobalConfiguration,
SmartInitializingSingleton,
DisposableBean,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Crane4jApplicationContext.class);
    private final ApplicationContext applicationContext;

    private static @Nullable Integer findOrderFromAnnotation(Object t) {
        if (!(t instanceof AnnotatedElement)) {
            return null;
        }
        Order annotation = (Order)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)((AnnotatedElement)t), Order.class);
        return Objects.nonNull(annotation) ? Integer.valueOf(annotation.value()) : null;
    }

    public ConverterManager getConverterManager() {
        return (ConverterManager)this.applicationContext.getBean(ConverterManager.class);
    }

    public PropertyOperator getPropertyOperator() {
        return (PropertyOperator)this.applicationContext.getBean(PropertyOperator.class);
    }

    public TypeResolver getTypeResolver() {
        return (TypeResolver)this.applicationContext.getBean(TypeResolver.class);
    }

    public <T extends ContainerProvider> @Nullable T getContainerProvider(String name) {
        ContainerProvider provider = super.getContainerProvider(name);
        return (T)(Objects.isNull(provider) && this.applicationContext.containsBean(name) ? (ContainerProvider)this.applicationContext.getBean(name, ContainerProvider.class) : provider);
    }

    public <K> @Nullable Container<K> getContainer(String namespace) {
        Container container = super.getContainer(namespace);
        return Objects.isNull(container) && this.applicationContext.containsBean(namespace) ? (Container)this.applicationContext.getBean(namespace, Container.class) : container;
    }

    public boolean containsContainer(String namespace) {
        return super.containsContainer(namespace) || this.applicationContext.containsBean(namespace);
    }

    public @NonNull BeanOperationExecutor getBeanOperationExecutor(@Nullable String executorName, Class<?> executorType) {
        return (BeanOperationExecutor)ConfigurationUtil.getComponentFromConfiguration(BeanOperationExecutor.class, executorType, (String)executorName, (t, n) -> (BeanOperationExecutor)this.applicationContext.getBean(n, t), arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0));
    }

    public @NonNull BeanOperationParser getBeanOperationsParser(@Nullable String parserName, Class<?> parserType) {
        return (BeanOperationParser)ConfigurationUtil.getComponentFromConfiguration(BeanOperationParser.class, parserType, (String)parserName, (t, n) -> (BeanOperationParser)this.applicationContext.getBean(n, t), arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0));
    }

    public @NonNull AssembleOperationHandler getAssembleOperationHandler(@Nullable String handlerName, Class<?> handlerType) {
        return (AssembleOperationHandler)ConfigurationUtil.getComponentFromConfiguration(AssembleOperationHandler.class, handlerType, (String)handlerName, (t, n) -> (AssembleOperationHandler)this.applicationContext.getBean(n, t), arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0));
    }

    public @NonNull DisassembleOperationHandler getDisassembleOperationHandler(@Nullable String handlerName, Class<?> handlerType) {
        return (DisassembleOperationHandler)ConfigurationUtil.getComponentFromConfiguration(DisassembleOperationHandler.class, handlerType, (String)handlerName, (t, n) -> (DisassembleOperationHandler)this.applicationContext.getBean(n, t), arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0));
    }

    public void afterPropertiesSet() {
        this.applicationContext.getBeansOfType(ContainerLifecycleProcessor.class).forEach((name, processor) -> {
            log.info("install container register aware [{}]", name);
            this.registerContainerLifecycleProcessor((ContainerLifecycleProcessor)processor);
        });
    }

    public void afterSingletonsInstantiated() {
        this.applicationContext.getBeansOfType(ContainerDefinition.class).values().forEach(arg_0 -> ((Crane4jApplicationContext)this).registerContainer(arg_0));
        this.applicationContext.getBeansOfType(Container.class).values().forEach(arg_0 -> ((Crane4jApplicationContext)this).registerContainer(arg_0));
        this.applicationContext.getBeansOfType(ContainerProvider.class).forEach((arg_0, arg_1) -> ((Crane4jApplicationContext)this).registerContainerProvider(arg_0, arg_1));
    }

    public void destroy() {
        log.info("global configuration has been destroyed.");
        this.clear();
    }

    public Crane4jApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    static {
        Crane4jGlobalSorter.INSTANCE.addCompareValueExtractor(t -> {
            if (Objects.isNull(t)) {
                return null;
            }
            if (t instanceof Ordered) {
                return ((Ordered)t).getOrder();
            }
            Integer order = Crane4jApplicationContext.findOrderFromAnnotation(t);
            if (Objects.isNull(order) && t instanceof DecoratingProxy) {
                order = Crane4jApplicationContext.findOrderFromAnnotation(((DecoratingProxy)t).getDecoratedClass());
            }
            return order;
        });
    }
}

