/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.aop;

import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;

public class AutoOperatePointcut
implements Pointcut {
    private final ClassFilter classFilter;
    private final MethodMatcher methodMatcher;

    public static AutoOperatePointcut create(ClassFilter filter, BiPredicate<Method, Class<?>> predicate) {
        AutoOperateMethodMatcher matcher = predicate::test;
        return new AutoOperatePointcut(filter, matcher);
    }

    public static AutoOperatePointcut forAnnotatedMethod(BiPredicate<Method, Class<?>> predicate) {
        ClassFilter filter = t -> Objects.isNull(t.getPackage()) || !ReflectUtils.isJdkElement((AnnotatedElement)t) && !t.getPackage().getName().startsWith("org.springframework.");
        return AutoOperatePointcut.create(filter, predicate);
    }

    public ClassFilter getClassFilter() {
        return this.classFilter;
    }

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public AutoOperatePointcut(ClassFilter classFilter, MethodMatcher methodMatcher) {
        this.classFilter = classFilter;
        this.methodMatcher = methodMatcher;
    }

    @FunctionalInterface
    static interface AutoOperateMethodMatcher
    extends MethodMatcher {
        default public boolean isRuntime() {
            return false;
        }

        default public boolean matches(@NonNull Method method, @NonNull Class<?> aClass, Object ... objects) {
            return false;
        }
    }
}

