/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.scanner;

import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.extension.spring.annotation.ContainerConstantScan;
import cn.crane4j.extension.spring.annotation.ContainerEnumScan;
import cn.crane4j.extension.spring.scanner.ClassScanner;
import cn.crane4j.extension.spring.util.ContainerResolveUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringValueResolver;

public class ScannedContainerRegistrar
implements ImportBeanDefinitionRegistrar,
InitializingBean,
EmbeddedValueResolverAware {
    private static final Logger log = LoggerFactory.getLogger(ScannedContainerRegistrar.class);
    private static final String SCANNED_CONTAINER_CONFIGURATION_BEAN_NAME = "internalScannedContainerConfigurationBeanName";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AnnotationFinder annotationFinder;
    @Autowired
    private PropertyOperator propertyOperator;
    @Autowired
    private Crane4jGlobalConfiguration configuration;
    @Autowired
    private ClassScanner classScanner;
    private StringValueResolver embeddedValueResolver;

    public void registerBeanDefinitions(@NonNull AnnotationMetadata importingClassMetadata, @NonNull BeanDefinitionRegistry registry) {
        AbstractBeanDefinition definition = BeanDefinitionBuilder.genericBeanDefinition(ScannedContainerConfiguration.class).addPropertyValue("constantContainerScan", (Object)importingClassMetadata.getAnnotationAttributes(ContainerConstantScan.class.getName())).addPropertyValue("enumContainerScan", (Object)importingClassMetadata.getAnnotationAttributes(ContainerEnumScan.class.getName())).setAutowireMode(0).getBeanDefinition();
        if (!registry.containsBeanDefinition(SCANNED_CONTAINER_CONFIGURATION_BEAN_NAME)) {
            log.info("load annotation metadata from @ContainerConstantScan or @ContainerEnumScan");
            registry.registerBeanDefinition(SCANNED_CONTAINER_CONFIGURATION_BEAN_NAME, (BeanDefinition)definition);
        }
    }

    public void afterPropertiesSet() {
        Set<Class<?>> types2;
        if (!this.applicationContext.containsBeanDefinition(SCANNED_CONTAINER_CONFIGURATION_BEAN_NAME)) {
            return;
        }
        ScannedContainerConfiguration scannedContainerConfiguration = (ScannedContainerConfiguration)this.applicationContext.getBean(SCANNED_CONTAINER_CONFIGURATION_BEAN_NAME, ScannedContainerConfiguration.class);
        log.info("register container which resolve from @ContainerConstantScan or @ContainerEnumScan");
        Optional.ofNullable(scannedContainerConfiguration.getConstantContainerScan()).map(attributes -> ContainerResolveUtils.resolveComponentTypesFromMetadata(attributes, this.classScanner, this.embeddedValueResolver)).filter(CollectionUtils::isNotEmpty).ifPresent(types -> ContainerResolveUtils.loadConstantClass(types, (ContainerManager)this.configuration, this.annotationFinder));
        AnnotationAttributes enumContainerScan = scannedContainerConfiguration.getEnumContainerScan();
        if (Objects.nonNull(enumContainerScan) && CollectionUtils.isNotEmpty(types2 = ContainerResolveUtils.resolveComponentTypesFromMetadata(enumContainerScan, this.classScanner, this.embeddedValueResolver))) {
            ContainerResolveUtils.loadContainerEnum(types2, enumContainerScan.getBoolean("isOnlyLoadAnnotatedEnum"), (ContainerManager)this.configuration, this.annotationFinder, this.propertyOperator);
        }
    }

    public void setEmbeddedValueResolver(StringValueResolver embeddedValueResolver) {
        this.embeddedValueResolver = embeddedValueResolver;
    }

    protected static class ScannedContainerConfiguration {
        private @Nullable AnnotationAttributes constantContainerScan;
        private @Nullable AnnotationAttributes enumContainerScan;

        protected ScannedContainerConfiguration() {
        }

        public void setConstantContainerScan(@Nullable AnnotationAttributes constantContainerScan) {
            this.constantContainerScan = constantContainerScan;
        }

        public void setEnumContainerScan(@Nullable AnnotationAttributes enumContainerScan) {
            this.enumContainerScan = enumContainerScan;
        }

        public @Nullable AnnotationAttributes getConstantContainerScan() {
            return this.constantContainerScan;
        }

        public @Nullable AnnotationAttributes getEnumContainerScan() {
            return this.enumContainerScan;
        }
    }
}

