/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.util;

import cn.crane4j.annotation.ContainerConstant;
import cn.crane4j.annotation.ContainerEnum;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.container.Containers;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ObjectUtils;
import cn.crane4j.core.util.StringUtils;
import cn.crane4j.extension.spring.scanner.ClassScanner;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.StringValueResolver;

public class ContainerResolveUtils {
    private static final Logger log = LoggerFactory.getLogger(ContainerResolveUtils.class);

    public static void loadConstantClass(Set<Class<?>> types, ContainerManager containerManager, AnnotationFinder annotationFinder) {
        ContainerResolveUtils.resolveConstantContainers(types, annotationFinder).stream().filter(container -> !containerManager.containsContainer(container.getNamespace())).forEach(arg_0 -> ((ContainerManager)containerManager).registerContainer(arg_0));
    }

    public static Collection<Container<Object>> resolveConstantContainers(Set<Class<?>> types, AnnotationFinder annotationFinder) {
        return types.stream().filter(type -> AnnotatedElementUtils.isAnnotated((AnnotatedElement)type, ContainerConstant.class)).map(type -> Containers.forConstantClass((Class)type, (AnnotationFinder)annotationFinder)).collect(Collectors.toList());
    }

    public static void loadContainerEnum(Set<Class<?>> types, boolean isOnlyLoadAnnotatedEnum, ContainerManager containerManager, AnnotationFinder annotationFinder, PropertyOperator propertyOperator) {
        ContainerResolveUtils.resolveEnumContainers(types, isOnlyLoadAnnotatedEnum, annotationFinder, propertyOperator).stream().filter(container -> !containerManager.containsContainer(container.getNamespace())).forEach(arg_0 -> ((ContainerManager)containerManager).registerContainer(arg_0));
    }

    public static Collection<Container<Object>> resolveEnumContainers(Set<Class<?>> types, boolean isOnlyLoadAnnotatedEnum, AnnotationFinder annotationFinder, PropertyOperator propertyOperator) {
        return types.stream().filter(Class::isEnum).filter(type -> !isOnlyLoadAnnotatedEnum || AnnotatedElementUtils.isAnnotated((AnnotatedElement)type, ContainerEnum.class)).map(type -> Containers.forEnum((Class)type, (AnnotationFinder)annotationFinder, (PropertyOperator)propertyOperator)).collect(Collectors.toList());
    }

    public static Set<Class<?>> resolveComponentTypesFromMetadata(AnnotationAttributes annotationAttributes, ClassScanner classScanner, @Nullable StringValueResolver stringValueResolver) {
        if (Objects.isNull(annotationAttributes)) {
            return Collections.emptySet();
        }
        Set<String> includePackages = ContainerResolveUtils.getIncludePackages(annotationAttributes, (StringValueResolver)ObjectUtils.defaultIfNull((Object)stringValueResolver, str -> str));
        Set includeTypes = includePackages.stream().map(xva$0 -> classScanner.scan((String)xva$0)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        includeTypes.addAll(ContainerResolveUtils.getIncludeClasses(annotationAttributes));
        includeTypes.removeAll(ContainerResolveUtils.getExcludeClasses(annotationAttributes));
        return includeTypes;
    }

    private static Set<String> getIncludePackages(AnnotationAttributes annotationAttributes, StringValueResolver stringValueResolver) {
        return Stream.of(annotationAttributes.getStringArray("includePackages")).filter(StringUtils::isNotEmpty).map(arg_0 -> ((StringValueResolver)stringValueResolver).resolveStringValue(arg_0)).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
    }

    private static Set<Class<?>> getIncludeClasses(AnnotationAttributes annotationAttributes) {
        Class[] classes = annotationAttributes.getClassArray("includeClasses");
        return Arrays.stream(classes).collect(Collectors.toSet());
    }

    private static Set<Class<?>> getExcludeClasses(AnnotationAttributes annotationAttributes) {
        Class[] classes = annotationAttributes.getClassArray("excludeClasses");
        return Arrays.stream(classes).collect(Collectors.toSet());
    }

    private ContainerResolveUtils() {
    }
}

