/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.jwt;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTException;
import java.util.Map;

public class SaJwtUtil {
    public static final String LOGIN_TYPE = "loginType";
    public static final String LOGIN_ID = "loginId";
    public static final String DEVICE = "device";
    public static final String EFF = "eff";
    public static final long NEVER_EXPIRE = -1L;

    public static String createToken(Object loginId, Map<String, Object> extraData, String keyt) {
        SaTokenException.throwByNull((Object)keyt, (String)"\u8bf7\u914d\u7f6ejwt\u79d8\u94a5");
        String token = JWT.create().setPayload(LOGIN_ID, loginId).setPayload("rn", (Object)SaFoxUtil.getRandomString((int)32)).addPayloads(extraData).setKey(keyt.getBytes()).sign();
        return token;
    }

    public static String createToken(String loginType, Object loginId, String device, long timeout, Map<String, Object> extraData, String keyt) {
        SaTokenException.throwByNull((Object)keyt, (String)"\u8bf7\u914d\u7f6ejwt\u79d8\u94a5");
        long effTime = timeout;
        if (timeout != -1L) {
            effTime = timeout * 1000L + System.currentTimeMillis();
        }
        JWT jwt = JWT.create().setPayload(LOGIN_TYPE, (Object)loginType).setPayload(LOGIN_ID, loginId).setPayload(DEVICE, (Object)device).setPayload(EFF, (Object)effTime).addPayloads(extraData);
        return jwt.setKey(keyt.getBytes()).sign();
    }

    public static JWT parseToken(String token, String keyt) {
        if (token == null) {
            throw NotLoginException.newInstance(null, (String)"-1");
        }
        JWT jwt = null;
        try {
            jwt = JWT.of((String)token);
        }
        catch (JWTException e) {
            throw NotLoginException.newInstance(null, (String)"-2", (String)token);
        }
        JSONObject payloads = jwt.getPayloads();
        boolean verify = jwt.setKey(keyt.getBytes()).verify();
        if (!verify) {
            throw NotLoginException.newInstance((String)payloads.getStr((Object)LOGIN_TYPE), (String)"-2", (String)token);
        }
        Long effTime = payloads.getLong((Object)EFF, Long.valueOf(0L));
        if (effTime != -1L && (effTime == null || effTime < System.currentTimeMillis())) {
            throw NotLoginException.newInstance((String)payloads.getStr((Object)LOGIN_TYPE), (String)"-3", (String)token);
        }
        return jwt;
    }

    public static JSONObject getPayloads(String token, String keyt) {
        return SaJwtUtil.parseToken(token, keyt).getPayloads();
    }

    public static JSONObject getPayloadsNotCheck(String token, String keyt) {
        try {
            JWT jwt = JWT.of((String)token);
            JSONObject payloads = jwt.getPayloads();
            boolean verify = jwt.setKey(keyt.getBytes()).verify();
            if (!verify) {
                throw NotLoginException.newInstance((String)payloads.getStr((Object)LOGIN_TYPE), (String)"-2", (String)token);
            }
            return payloads;
        }
        catch (JWTException e) {
            return new JSONObject();
        }
    }

    public static Object getLoginId(String token, String keyt) {
        return SaJwtUtil.getPayloads(token, keyt).get((Object)LOGIN_ID);
    }

    public static Object getLoginIdOrNull(String token, String keyt) {
        try {
            return SaJwtUtil.getPayloads(token, keyt).get((Object)LOGIN_ID);
        }
        catch (NotLoginException e) {
            return null;
        }
    }

    public static long getTimeout(String token, String keyt) {
        if (token == null) {
            return -2L;
        }
        JWT jwt = null;
        try {
            jwt = JWT.of((String)token);
        }
        catch (JWTException e) {
            return -2L;
        }
        JSONObject payloads = jwt.getPayloads();
        boolean verify = jwt.setKey(keyt.getBytes()).verify();
        if (!verify) {
            return -2L;
        }
        Long effTime = (Long)payloads.get((Object)EFF, Long.class);
        if (effTime == -1L) {
            return -1L;
        }
        if (effTime == null || effTime < System.currentTimeMillis()) {
            return -2L;
        }
        return (effTime - System.currentTimeMillis()) / 1000L;
    }

    @Deprecated
    public static String createToken(Object loginId, String keyt) {
        return SaJwtUtil.createToken(loginId, null, keyt);
    }

    @Deprecated
    public static String createToken(String loginType, Object loginId, String device, long timeout, String keyt) {
        return SaJwtUtil.createToken(loginType, loginId, device, timeout, null, keyt);
    }
}

