/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.ali;

import cn.gjing.tools.ali.Sms;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.google.gson.Gson;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class AliSms {
    private IAcsClient instance;

    private AliSms(String accessKeyId, String accessKeySecret) {
        DefaultProfile profile = DefaultProfile.getProfile((String)"default", (String)accessKeyId, (String)accessKeySecret);
        this.instance = new DefaultAcsClient((IClientProfile)profile);
    }

    public static AliSms of(String accessKeyId, String accessKeySecret) {
        Objects.requireNonNull(accessKeyId, "accessKeyId cannot be null");
        Objects.requireNonNull(accessKeySecret, "accessKeySecret cannot be null");
        return new AliSms(accessKeyId, accessKeySecret);
    }

    public String send(String phoneNumbers, String smsTemplateCode, Map<String, String> smsTemplateParam, String smsSignName) {
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(Sms.SMS.getApi());
        request.setAction(Sms.SMS.getAction());
        request.setVersion(Sms.SMS.getVersion());
        request.putQueryParameter("PhoneNumbers", phoneNumbers);
        request.putQueryParameter("TemplateCode", smsTemplateCode);
        if (!StringUtils.isEmpty(smsTemplateParam)) {
            request.putQueryParameter("TemplateParam", new Gson().toJson(smsTemplateParam));
        }
        request.putQueryParameter("SignName", smsSignName);
        try {
            CommonResponse response = this.instance.getCommonResponse(request);
            return response.getData();
        }
        catch (ClientException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String querySendDetails(String phoneNumber, String sendData, String pageSize, String currentPage) {
        if (Integer.parseInt(pageSize) < 1 || Integer.parseInt(pageSize) > 50) {
            throw new IllegalArgumentException("PageSize is not valid, It can't be less than 1 or more than 50");
        }
        if (Integer.parseInt(currentPage) < 1) {
            throw new IllegalArgumentException("currentPage is not valid, No less than 1");
        }
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(Sms.QUERY.getApi());
        request.setAction(Sms.QUERY.getAction());
        request.setVersion(Sms.QUERY.getVersion());
        request.putQueryParameter("PhoneNumber", phoneNumber);
        request.putQueryParameter("SendDate", sendData.replaceAll("-", ""));
        request.putQueryParameter("PageSize", pageSize);
        request.putQueryParameter("CurrentPage", currentPage);
        try {
            CommonResponse response = this.instance.getCommonResponse(request);
            return response.getData();
        }
        catch (ClientException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

