/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.enums;

import cn.herodotus.engine.assistant.definition.enums.BaseUiEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Schema(title="\u6570\u636e\u5e93\u7c7b\u522b")
@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum Database implements BaseUiEnum<Integer>
{
    ORACLE(0, "Oracle"),
    POSTGRESQL(1, "PostgreSQL"),
    MYSQL(2, "Mysql"),
    MARIADB(3, "MariaDB"),
    SQLSERVER(4, "SQLServer"),
    SYBASE(5, "SyBase"),
    SAPDB(6, "SAPDB"),
    DB2(7, "DB2"),
    H2(8, "H2"),
    REDIS(9, "Redis");

    private static final Map<Integer, Database> INDEX_MAP;
    private static final List<Map<String, Object>> JSON_STRUCTURE;
    @Schema(title="\u679a\u4e3e\u503c")
    private final Integer value;
    @Schema(name="\u6587\u5b57")
    private final String description;

    private Database(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Database get(Integer index) {
        return INDEX_MAP.get(index);
    }

    public static List<Map<String, Object>> getPreprocessedJsonStructure() {
        return JSON_STRUCTURE;
    }

    @JsonValue
    public Integer getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        INDEX_MAP = new HashMap<Integer, Database>();
        JSON_STRUCTURE = new ArrayList<Map<String, Object>>();
        for (Database database : Database.values()) {
            INDEX_MAP.put(database.getValue(), database);
            JSON_STRUCTURE.add(database.getValue(), (Map<String, Object>)ImmutableMap.builder().put((Object)"value", (Object)database.getValue()).put((Object)"key", (Object)database.name()).put((Object)"text", (Object)database.getDescription()).put((Object)"index", (Object)database.getValue()).build());
        }
    }
}

