/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.exception;

import cn.herodotus.engine.assistant.definition.constants.ErrorCodes;
import cn.herodotus.engine.assistant.definition.domain.Feedback;
import cn.herodotus.engine.assistant.definition.domain.Result;
import cn.herodotus.engine.assistant.definition.exception.HerodotusException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final Map<String, Feedback> EXCEPTION_DICTIONARY = new HashMap<String, Feedback>();

    public static Result<String> resolveException(Exception ex, String path) {
        log.trace("[Herodotus] |- Global Exception Handler, Path : [{}], Exception\uff1a", (Object)path, (Object)ex);
        if (ex instanceof HerodotusException) {
            HerodotusException exception = (HerodotusException)ex;
            Result result = exception.getResult();
            result.path(path);
            log.error("[Herodotus] |- Global Exception Handler, Error is : {}", (Object)result);
            return result;
        }
        Result result = Result.failure();
        String exceptionName = ex.getClass().getSimpleName();
        if (StringUtils.isNotEmpty((CharSequence)exceptionName) && EXCEPTION_DICTIONARY.containsKey(exceptionName)) {
            Feedback feedback = EXCEPTION_DICTIONARY.get(exceptionName);
            result = Result.failure((Feedback)feedback, (Object)exceptionName);
        } else {
            log.warn("[Herodotus] |- Global Exception Handler,  Can not find the exception name [{}] in dictionary, please do optimize ", (Object)exceptionName);
        }
        result.path(path);
        result.stackTrace(ex.getStackTrace());
        result.detail(ex.getMessage());
        log.error("[Herodotus] |- Global Exception Handler, Error is : {}", (Object)result);
        return result;
    }

    static {
        EXCEPTION_DICTIONARY.put("AccessDeniedException", (Feedback)ErrorCodes.ACCESS_DENIED);
        EXCEPTION_DICTIONARY.put("InsufficientAuthenticationException", (Feedback)ErrorCodes.ACCESS_DENIED);
        EXCEPTION_DICTIONARY.put("HttpRequestMethodNotSupportedException", (Feedback)ErrorCodes.HTTP_REQUEST_METHOD_NOT_SUPPORTED);
        EXCEPTION_DICTIONARY.put("HttpMediaTypeNotAcceptableException", (Feedback)ErrorCodes.HTTP_MEDIA_TYPE_NOT_ACCEPTABLE);
        EXCEPTION_DICTIONARY.put("IllegalArgumentException", (Feedback)ErrorCodes.ILLEGAL_ARGUMENT_EXCEPTION);
        EXCEPTION_DICTIONARY.put("NullPointerException", (Feedback)ErrorCodes.NULL_POINTER_EXCEPTION);
        EXCEPTION_DICTIONARY.put("IOException", (Feedback)ErrorCodes.IO_EXCEPTION);
        EXCEPTION_DICTIONARY.put("HttpMessageNotReadableException", (Feedback)ErrorCodes.HTTP_MESSAGE_NOT_READABLE_EXCEPTION);
        EXCEPTION_DICTIONARY.put("TypeMismatchException", (Feedback)ErrorCodes.TYPE_MISMATCH_EXCEPTION);
        EXCEPTION_DICTIONARY.put("MissingServletRequestParameterException", (Feedback)ErrorCodes.MISSING_SERVLET_REQUEST_PARAMETER_EXCEPTION);
        EXCEPTION_DICTIONARY.put("ProviderNotFoundException", (Feedback)ErrorCodes.PROVIDER_NOT_FOUND);
        EXCEPTION_DICTIONARY.put("CookieTheftException", (Feedback)ErrorCodes.COOKIE_THEFT);
        EXCEPTION_DICTIONARY.put("InvalidCookieException", (Feedback)ErrorCodes.INVALID_COOKIE);
        EXCEPTION_DICTIONARY.put("BadSqlGrammarException", (Feedback)ErrorCodes.BAD_SQL_GRAMMAR);
        EXCEPTION_DICTIONARY.put("DataIntegrityViolationException", (Feedback)ErrorCodes.DATA_INTEGRITY_VIOLATION);
        EXCEPTION_DICTIONARY.put("TransactionRollbackException", (Feedback)ErrorCodes.TRANSACTION_ROLLBACK);
        EXCEPTION_DICTIONARY.put("BindException", (Feedback)ErrorCodes.METHOD_ARGUMENT_NOT_VALID);
        EXCEPTION_DICTIONARY.put("MethodArgumentNotValidException", (Feedback)ErrorCodes.METHOD_ARGUMENT_NOT_VALID);
        EXCEPTION_DICTIONARY.put("RedisPipelineException", (Feedback)ErrorCodes.PIPELINE_INVALID_COMMANDS);
    }
}

