/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.json.jackson2.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson2YamlUtils {
    private static final Logger log = LoggerFactory.getLogger(Jackson2YamlUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    private static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static <T> String writeAsString(T entity) {
        return Jackson2YamlUtils.writeAsString(entity, true);
    }

    public static <D> String writeAsString(D domain, boolean removeQuote) {
        try {
            String yaml = Jackson2YamlUtils.getObjectMapper().writeValueAsString(domain);
            if (StringUtils.isNotBlank((CharSequence)yaml) && removeQuote) {
                return StringUtils.remove((String)yaml, (String)"\"");
            }
            return yaml;
        }
        catch (JsonProcessingException e) {
            log.error("[Herodotus] |- Yaml writeAsString processing error! {}", (Object)e.getMessage());
            return null;
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

