/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);
    private static volatile ResourceUtils INSTANCE;
    private final PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();

    private ResourceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResourceUtils getInstance() {
        if (!ObjectUtils.isEmpty((Object)INSTANCE)) return INSTANCE;
        Class<ResourceUtils> clazz = ResourceUtils.class;
        synchronized (ResourceUtils.class) {
            if (!ObjectUtils.isEmpty((Object)INSTANCE)) return INSTANCE;
            INSTANCE = new ResourceUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private PathMatchingResourcePatternResolver getPathMatchingResourcePatternResolver() {
        return this.pathMatchingResourcePatternResolver;
    }

    private static PathMatchingResourcePatternResolver getResolver() {
        return ResourceUtils.getInstance().getPathMatchingResourcePatternResolver();
    }

    public static Resource getResource(String location) {
        return ResourceUtils.getResolver().getResource(location);
    }

    public static File getFile(String location) throws IOException {
        return ResourceUtils.getResource(location).getFile();
    }

    public static InputStream getInputStream(String location) throws IOException {
        return ResourceUtils.getResource(location).getInputStream();
    }

    public static String getFilename(String location) {
        return ResourceUtils.getResource(location).getFilename();
    }

    public static URI getURI(String location) throws IOException {
        return ResourceUtils.getResource(location).getURI();
    }

    public static URL getURL(String location) throws IOException {
        return ResourceUtils.getResource(location).getURL();
    }

    public static long contentLength(String location) throws IOException {
        return ResourceUtils.getResource(location).contentLength();
    }

    public static long lastModified(String location) throws IOException {
        return ResourceUtils.getResource(location).lastModified();
    }

    public static boolean exists(String location) {
        return ResourceUtils.getResource(location).exists();
    }

    public static boolean isFile(String location) {
        return ResourceUtils.getResource(location).isFile();
    }

    public static boolean isReadable(String location) {
        return ResourceUtils.getResource(location).isReadable();
    }

    public static boolean isOpen(String location) {
        return ResourceUtils.getResource(location).isOpen();
    }

    public static Resource[] getResources(String locationPattern) throws IOException {
        return ResourceUtils.getResolver().getResources(locationPattern);
    }

    public static boolean isUrl(String location) {
        return org.springframework.util.ResourceUtils.isUrl((String)location);
    }

    public static boolean isClasspathUrl(String location) {
        return StringUtils.startsWith((CharSequence)location, (CharSequence)"classpath:");
    }

    public static boolean isClasspathAllUrl(String location) {
        return StringUtils.startsWith((CharSequence)location, (CharSequence)"classpath*:");
    }

    public static boolean isJarUrl(URL url) {
        return org.springframework.util.ResourceUtils.isJarURL((URL)url);
    }

    public static boolean isFileUrl(URL url) {
        return org.springframework.util.ResourceUtils.isFileURL((URL)url);
    }

    public static byte[] toBytes(Resource resource) {
        try {
            InputStream inputStream = resource.getInputStream();
            return FileCopyUtils.copyToByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Converter resource to byte[] error!", (Throwable)e);
            return null;
        }
    }

    public static String toBase64(Resource resource) {
        byte[] bytes = ResourceUtils.toBytes(resource);
        return Base64.encode((byte[])bytes);
    }
}

