/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.utils.http;

import cn.herodotus.engine.assistant.core.utils.http.HeaderUtils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.web.util.WebUtils;

public class CookieUtils {
    private static Map<String, String> rawCookieToMap(String cookie) {
        if (StringUtils.isNotBlank((CharSequence)cookie)) {
            return Stream.of(cookie.split("; ")).map(pair -> pair.split("=")).collect(Collectors.toMap(kv -> kv[0], kv -> kv[1]));
        }
        return Collections.emptyMap();
    }

    public static List<String> get(String cookie, String ... name) {
        Map<String, String> cookies = CookieUtils.rawCookieToMap(cookie);
        return Stream.of(name).map(cookies::get).toList();
    }

    public static String getAny(String cookie, String ... name) {
        List<String> result = CookieUtils.get(cookie, name);
        return CollectionUtils.isNotEmpty(result) ? result.get(0) : null;
    }

    public static String get(String cookie, String name) {
        Map<String, String> cookies = CookieUtils.rawCookieToMap(cookie);
        return cookies.get(name);
    }

    public static Cookie get(HttpServletRequest httpServletRequest, String name) {
        return WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)name);
    }

    public static String getValue(HttpServletRequest httpServletRequest, String name) {
        Cookie cookie = CookieUtils.get(httpServletRequest, name);
        return ObjectUtils.isNotEmpty((Object)cookie) ? cookie.getValue() : null;
    }

    public static String getFromHeader(HttpServletRequest httpServletRequest, String name) {
        String cookie = HeaderUtils.getCookie(httpServletRequest);
        return CookieUtils.get(cookie, name);
    }

    public static String getFromHeader(ServerHttpRequest serverHttpRequest, String name) {
        String cookie = HeaderUtils.getCookie(serverHttpRequest);
        return CookieUtils.get(cookie, name);
    }

    public static String getFromHeader(HttpInputMessage httpInputMessage, String name) {
        String cookie = HeaderUtils.getCookie(httpInputMessage);
        return CookieUtils.get(cookie, name);
    }

    public static String getAnyFromHeader(HttpServletRequest httpServletRequest, String ... name) {
        String cookie = HeaderUtils.getCookie(httpServletRequest);
        return CookieUtils.getAny(cookie, name);
    }

    public static String getAnyFromHeader(ServerHttpRequest serverHttpRequest, String ... name) {
        String cookie = HeaderUtils.getCookie(serverHttpRequest);
        return CookieUtils.getAny(cookie, name);
    }

    public static String getAnyFromHeader(HttpInputMessage httpInputMessage, String ... name) {
        String cookie = HeaderUtils.getCookie(httpInputMessage);
        return CookieUtils.getAny(cookie, name);
    }

    public static void removeCookie(HttpServletResponse response, String key) {
        CookieUtils.setCookie(response, key, null, 0);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }
}

