/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.captcha.graphic.renderer;

import cn.herodotus.engine.captcha.core.definition.domain.Metadata;
import cn.herodotus.engine.captcha.core.definition.enums.CaptchaCategory;
import cn.herodotus.engine.captcha.core.provider.RandomProvider;
import cn.herodotus.engine.captcha.graphic.definition.AbstractBaseGraphicRenderer;
import java.awt.image.BufferedImage;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ArithmeticCaptchaRenderer
extends AbstractBaseGraphicRenderer {
    private static final Logger log = LoggerFactory.getLogger(ArithmeticCaptchaRenderer.class);
    private int complexity = 2;
    private String computedResult;

    public String getCategory() {
        return CaptchaCategory.ARITHMETIC.getConstant();
    }

    @Override
    protected String[] getDrawCharacters() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.complexity; ++i) {
            builder.append(RandomProvider.randomInt((int)10));
            if (i >= this.complexity - 1) continue;
            int type = RandomProvider.randomInt((int)1, (int)4);
            if (type == 1) {
                builder.append("+");
                continue;
            }
            if (type == 2) {
                builder.append("-");
                continue;
            }
            if (type != 3) continue;
            builder.append("x");
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("javascript");
        try {
            this.computedResult = String.valueOf(engine.eval(builder.toString().replaceAll("x", "*")));
        }
        catch (ScriptException e) {
            log.error("[Herodotus] |- Arithmetic png captcha eval expression error\uff01", (Throwable)e);
        }
        builder.append("=?");
        String result = builder.toString();
        return result.split("(?!^)");
    }

    public Metadata draw() {
        String[] drawContent = this.getDrawCharacters();
        BufferedImage bufferedImage = this.createArithmeticBufferedImage(drawContent);
        Metadata metadata = new Metadata();
        metadata.setGraphicImageBase64(this.toBase64(bufferedImage));
        metadata.setCharacters(this.computedResult);
        return metadata;
    }

    public void afterPropertiesSet() throws Exception {
        this.complexity = this.getCaptchaProperties().getGraphics().getComplexity();
    }
}

