/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.crypto.processor;

import cn.herodotus.engine.assistant.definition.domain.oauth2.SecretKey;
import cn.herodotus.engine.cache.core.exception.StampHasExpiredException;
import cn.herodotus.engine.cache.jetcache.stamp.AbstractStampManager;
import cn.herodotus.engine.rest.core.definition.crypto.AsymmetricCryptoProcessor;
import cn.herodotus.engine.rest.core.definition.crypto.SymmetricCryptoProcessor;
import cn.herodotus.engine.rest.core.exception.SessionInvalidException;
import java.time.Duration;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.data.id.IdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCryptoProcessor
extends AbstractStampManager<String, SecretKey> {
    private static final Logger log = LoggerFactory.getLogger(HttpCryptoProcessor.class);
    private final AsymmetricCryptoProcessor asymmetricCryptoProcessor;
    private final SymmetricCryptoProcessor symmetricCryptoProcessor;

    public HttpCryptoProcessor(AsymmetricCryptoProcessor asymmetricCryptoProcessor, SymmetricCryptoProcessor symmetricCryptoProcessor) {
        super("cache:token:secure_key:");
        this.asymmetricCryptoProcessor = asymmetricCryptoProcessor;
        this.symmetricCryptoProcessor = symmetricCryptoProcessor;
    }

    public String encrypt(String identity, String content) {
        try {
            SecretKey secretKey = this.getSecretKey(identity);
            String result = this.symmetricCryptoProcessor.encrypt(content, secretKey.getSymmetricKey());
            log.debug("[Herodotus] |- Encrypt content from [{}] to [{}].", (Object)content, (Object)result);
            return result;
        }
        catch (StampHasExpiredException e) {
            log.warn("[Herodotus] |- Session has expired, need recreate, Skip encrypt content [{}].", (Object)content);
            return content;
        }
        catch (Exception e) {
            log.warn("[Herodotus] |- Symmetric can not Encrypt content [{}], Skip!", (Object)content);
            return content;
        }
    }

    public String decrypt(String identity, String content) {
        try {
            SecretKey secretKey = this.getSecretKey(identity);
            String result = this.symmetricCryptoProcessor.decrypt(content, secretKey.getSymmetricKey());
            log.debug("[Herodotus] |- Decrypt content from [{}] to [{}].", (Object)content, (Object)result);
            return result;
        }
        catch (StampHasExpiredException e) {
            log.warn("[Herodotus] |- Session has expired, need recreate, Skip decrypt content [{}].", (Object)content);
            return content;
        }
        catch (Exception e) {
            log.warn("[Herodotus] |- Symmetric can not Decrypt content [{}], Skip!", (Object)content);
            return content;
        }
    }

    public SecretKey createSecretKey(String identity, Duration accessTokenValiditySeconds) {
        if (StringUtils.isBlank((CharSequence)identity)) {
            identity = IdUtil.fastUUID();
        }
        Duration expire = this.getExpire(accessTokenValiditySeconds);
        return (SecretKey)this.create(identity, expire);
    }

    public SecretKey nextStamp(String key) {
        SecretKey secretKey = this.asymmetricCryptoProcessor.createSecretKey();
        String symmetricKey = this.symmetricCryptoProcessor.createKey();
        secretKey.setSymmetricKey(symmetricKey);
        secretKey.setIdentity(key);
        secretKey.setState(IdUtil.fastUUID());
        log.debug("[Herodotus] |- Generate secret key, value is : [{}]", (Object)secretKey);
        return secretKey;
    }

    private boolean isSessionValid(String identity) {
        return this.containKey(identity);
    }

    private SecretKey getSecretKey(String identity) throws StampHasExpiredException {
        SecretKey secretKey;
        if (this.isSessionValid(identity) && ObjectUtils.isNotEmpty((Object)(secretKey = (SecretKey)this.get(identity)))) {
            log.trace("[Herodotus] |- Decrypt Or Encrypt content use param identity [{}], cached identity is [{}].", (Object)identity, (Object)secretKey.getIdentity());
            return secretKey;
        }
        throw new StampHasExpiredException("SecretKey key is expired!");
    }

    private Duration getExpire(Duration accessTokenValiditySeconds) {
        if (ObjectUtils.isEmpty((Object)accessTokenValiditySeconds) || accessTokenValiditySeconds.isZero()) {
            return Duration.ofHours(2L);
        }
        return accessTokenValiditySeconds;
    }

    private String decryptFrontendPublicKey(String content, String privateKey) {
        String frontendPublicKey = this.asymmetricCryptoProcessor.decrypt(content, privateKey);
        log.debug("[Herodotus] |- Decrypt frontend public key, value is : [{}]", (Object)frontendPublicKey);
        return frontendPublicKey;
    }

    private String encryptBackendKey(String symmetricKey, String publicKey) {
        String encryptedAesKey = this.asymmetricCryptoProcessor.encrypt(symmetricKey, publicKey);
        log.debug("[Herodotus] |- Encrypt symmetric key use frontend public key, value is : [{}]", (Object)encryptedAesKey);
        return encryptedAesKey;
    }

    public String exchange(String identity, String confidential) {
        try {
            SecretKey secretKey = this.getSecretKey(identity);
            String frontendPublicKey = this.decryptFrontendPublicKey(confidential, secretKey.getPrivateKey());
            return this.encryptBackendKey(secretKey.getSymmetricKey(), frontendPublicKey);
        }
        catch (StampHasExpiredException e) {
            throw new SessionInvalidException();
        }
    }

    public void afterPropertiesSet() throws Exception {
    }
}

