/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.crypto.processor;

import cn.herodotus.engine.assistant.definition.domain.oauth2.SecretKey;
import cn.herodotus.engine.rest.core.definition.crypto.AsymmetricCryptoProcessor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.asymmetric.RSA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACryptoProcessor
implements AsymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(RSACryptoProcessor.class);
    private static final String PKCS8_PUBLIC_KEY_BEGIN = "-----BEGIN PUBLIC KEY-----";
    private static final String PKCS8_PUBLIC_KEY_END = "-----END PUBLIC KEY-----";

    public SecretKey createSecretKey() {
        RSA rsa = SecureUtil.rsa();
        SecretKey secretKey = new SecretKey();
        secretKey.setPrivateKey(rsa.getPrivateKeyBase64());
        secretKey.setPublicKey(this.appendPkcs8Padding(rsa.getPublicKeyBase64()));
        return secretKey;
    }

    private String removePkcs8Padding(String key) {
        String result = StringUtils.replace((String)key, (String)"\n", (String)"");
        Object[] values = StringUtils.split((String)result, (String)"-----");
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            return values[1];
        }
        return key;
    }

    public String appendPkcs8Padding(String key) {
        return "-----BEGIN PUBLIC KEY-----\n" + key + "\n-----END PUBLIC KEY-----";
    }

    public String decrypt(String content, String privateKey) {
        byte[] base64Data = Base64.decode((CharSequence)content);
        RSA rsa = SecureUtil.rsa((String)privateKey, null);
        String result = StrUtil.utf8Str((Object)rsa.decrypt(base64Data, KeyType.PrivateKey));
        log.trace("[Herodotus] |- RSA crypto decrypt data, value is : [{}]", (Object)result);
        return result;
    }

    public String encrypt(String content, String publicKey) {
        String key = this.removePkcs8Padding(publicKey);
        RSA rsa = SecureUtil.rsa(null, (String)key);
        byte[] encryptedData = rsa.encrypt(content, KeyType.PublicKey);
        String result = Base64.encode((byte[])encryptedData);
        log.trace("[Herodotus] |- RSA crypto decrypt data, value is : [{}]", (Object)result);
        return result;
    }
}

