/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.crypto.processor;

import cn.herodotus.engine.rest.core.definition.crypto.SymmetricCryptoProcessor;
import javax.crypto.SecretKey;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.crypto.bc.SmUtil;
import org.dromara.hutool.crypto.symmetric.SM4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4CryptoProcessor
implements SymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(SM4CryptoProcessor.class);

    public String createKey() {
        SM4 sm4 = SmUtil.sm4();
        SecretKey secretKey = sm4.getSecretKey();
        byte[] encoded = secretKey.getEncoded();
        String result = HexUtil.encodeStr((byte[])encoded);
        log.trace("[Herodotus] |- SM4 crypto create hex key, value is : [{}]", (Object)result);
        return result;
    }

    public String decrypt(String data, String key) {
        SM4 sm4 = SmUtil.sm4((byte[])HexUtil.decode((String)key));
        log.trace("[Herodotus] |- SM4 crypto decrypt data [{}] with key : [{}]", (Object)data, (Object)key);
        String result = sm4.decryptStr(data);
        log.trace("[Herodotus] |- SM4 crypto decrypt result is : [{}]", (Object)result);
        return result;
    }

    public String encrypt(String data, String key) {
        SM4 sm4 = SmUtil.sm4((byte[])HexUtil.decode((String)key));
        log.trace("[Herodotus] |- SM4 crypto encrypt data [{}] with key : [{}]", (Object)data, (Object)key);
        String result = sm4.encryptHex(data);
        log.trace("[Herodotus] |- SM4 crypto encrypt result is : [{}]", (Object)result);
        return result;
    }
}

