/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.secure.interceptor;

import cn.herodotus.engine.rest.core.annotation.AccessLimited;
import cn.herodotus.engine.rest.core.definition.AbstractBaseHandlerInterceptor;
import cn.herodotus.engine.rest.core.exception.FrequentRequestsException;
import cn.herodotus.engine.rest.protect.secure.stamp.AccessLimitedStampManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;

public class AccessLimitedInterceptor
extends AbstractBaseHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AccessLimitedInterceptor.class);
    private AccessLimitedStampManager accessLimitedStampManager;

    public void setAccessLimitedStampManager(AccessLimitedStampManager accessLimitedStampManager) {
        this.accessLimitedStampManager = accessLimitedStampManager;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.trace("[Herodotus] |- AccessLimitedInterceptor preHandle postProcess.");
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        AccessLimited accessLimited = method.getAnnotation(AccessLimited.class);
        if (ObjectUtils.isNotEmpty((Object)accessLimited)) {
            String annotationDuration;
            int maxTimes = this.accessLimitedStampManager.getSecureProperties().getAccessLimited().getMaxTimes();
            Duration expireDuration = Duration.ZERO;
            int annotationMaxTimes = accessLimited.maxTimes();
            if (annotationMaxTimes != 0) {
                maxTimes = annotationMaxTimes;
            }
            if (StringUtils.isNotBlank((CharSequence)(annotationDuration = accessLimited.duration()))) {
                try {
                    expireDuration = Duration.parse(annotationDuration);
                }
                catch (DateTimeParseException e) {
                    log.warn("[Herodotus] |- AccessLimited duration value is incorrect, on api [{}].", (Object)request.getRequestURI());
                }
            }
            String key = this.generateRequestKey(request);
            String expireKey = key + "_expire";
            Long times = (Long)this.accessLimitedStampManager.get(key);
            if (ObjectUtils.isEmpty((Object)times) || times == 0L) {
                if (!expireDuration.isZero()) {
                    this.accessLimitedStampManager.create(key, expireDuration);
                    this.accessLimitedStampManager.put(expireKey, System.currentTimeMillis(), expireDuration);
                } else {
                    this.accessLimitedStampManager.create(key);
                    this.accessLimitedStampManager.put(expireKey, System.currentTimeMillis());
                }
                return true;
            }
            log.debug("[Herodotus] |- AccessLimitedInterceptor request [{}] times.", (Object)times);
            if (times <= (long)maxTimes) {
                Duration newDuration = this.calculateRemainingTime(expireDuration, expireKey);
                this.accessLimitedStampManager.put(key, times + 1L, newDuration);
                return true;
            }
            throw new FrequentRequestsException("Requests are too frequent. Please try again later!");
        }
        return true;
    }

    private Duration calculateRemainingTime(Duration configuredDuration, String expireKey) {
        Long begin = (Long)this.accessLimitedStampManager.get(expireKey);
        Long current = System.currentTimeMillis();
        long interval = current - begin;
        log.debug("[Herodotus] |- AccessLimitedInterceptor operation interval [{}] millis.", (Object)interval);
        Duration duration = !configuredDuration.isZero() ? configuredDuration.minusMillis(interval) : this.accessLimitedStampManager.getExpire().minusMillis(interval);
        return duration;
    }
}

