/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.secure.interceptor;

import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.definition.AbstractBaseHandlerInterceptor;
import cn.herodotus.engine.rest.core.exception.RepeatSubmissionException;
import cn.herodotus.engine.rest.protect.secure.stamp.IdempotentStampManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;

public class IdempotentInterceptor
extends AbstractBaseHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(IdempotentInterceptor.class);
    private static final String IDEMPOTENT_ATTRIBUTE = "Idempotent";
    private IdempotentStampManager idempotentStampManager;

    public void setIdempotentStampManager(IdempotentStampManager idempotentStampManager) {
        this.idempotentStampManager = idempotentStampManager;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String key;
        log.trace("[Herodotus] |- IdempotentInterceptor preHandle postProcess.");
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        if (idempotent != null && StringUtils.isNotBlank((CharSequence)(key = this.generateRequestKey(request)))) {
            String token = (String)this.idempotentStampManager.get(key);
            if (StringUtils.isBlank((CharSequence)token)) {
                Duration configuredDuration = Duration.ZERO;
                String annotationExpire = idempotent.expire();
                if (StringUtils.isNotBlank((CharSequence)annotationExpire)) {
                    try {
                        configuredDuration = Duration.parse(annotationExpire);
                    }
                    catch (DateTimeParseException e) {
                        log.warn("[Herodotus] |- Idempotent duration value is incorrect, on api [{}].", (Object)request.getRequestURI());
                    }
                }
                if (!configuredDuration.isZero()) {
                    this.idempotentStampManager.create(key, configuredDuration);
                } else {
                    this.idempotentStampManager.create(key);
                }
                request.setAttribute(IDEMPOTENT_ATTRIBUTE, (Object)key);
                return true;
            }
            throw new RepeatSubmissionException("Don't Repeat Submission");
        }
        return true;
    }
}

