/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.secure.interceptor;

import cn.herodotus.engine.assistant.core.utils.protect.XssUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    private String cleaning(String value) {
        return XssUtils.cleaning((String)value);
    }

    private String[] cleaning(String[] parameters) {
        List<String> cleanParameters = Arrays.stream(parameters).map(XssUtils::cleaning).collect(Collectors.toList());
        String[] results = new String[cleanParameters.size()];
        return cleanParameters.toArray(results);
    }

    public String getHeader(String name) {
        String header = super.getHeader(name);
        return StringUtils.isBlank((CharSequence)header) ? header : this.cleaning(header);
    }

    public String getParameter(String name) {
        String parameter = super.getParameter(name);
        return StringUtils.isBlank((CharSequence)parameter) ? parameter : this.cleaning(parameter);
    }

    public String[] getParameterValues(String name) {
        Object[] parameterValues = super.getParameterValues(name);
        if (ArrayUtils.isNotEmpty((Object[])parameterValues)) {
            return this.cleaning((String[])parameterValues);
        }
        return super.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        Map parameterMap = super.getParameterMap();
        return parameterMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.cleaning((String[])entry.getValue())));
    }
}

