/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.tenant;

import cn.herodotus.engine.assistant.core.context.TenantContextHolder;
import cn.herodotus.engine.assistant.core.utils.http.HeaderUtils;
import cn.herodotus.engine.assistant.core.utils.http.SessionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class MultiTenantInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String tenantId = HeaderUtils.getHerodotusTenantId((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            tenantId = "public";
        }
        TenantContextHolder.setTenantId((String)tenantId);
        log.debug("[Herodotus] |- TENANT ID is : [{}].", (Object)tenantId);
        String path = request.getRequestURI();
        String sessionId = SessionUtils.getSessionId((HttpServletRequest)request);
        String herodotusSessionId = HeaderUtils.getHerodotusSessionId((HttpServletRequest)request);
        log.debug("[Herodotus] |- SESSION ID for [{}] is : [{}].", (Object)path, (Object)sessionId);
        log.debug("[Herodotus] |- SESSION ID of HERODOTUS for [{}] is : [{}].", (Object)path, (Object)herodotusSessionId);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String path = request.getRequestURI();
        TenantContextHolder.clear();
        log.debug("[Herodotus] |- Tenant Interceptor CLEAR tenantId for request [{}].", (Object)path);
    }
}

