/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.domain;

import cn.herodotus.oss.dialect.minio.converter.domain.InitiatorToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.OwnerToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.PartToDomainConverter;
import cn.herodotus.oss.specification.arguments.multipart.ListPartsArguments;
import cn.herodotus.oss.specification.domain.base.OwnerDomain;
import cn.herodotus.oss.specification.domain.multipart.ListPartsDomain;
import cn.herodotus.oss.specification.domain.multipart.PartSummaryDomain;
import io.minio.messages.Initiator;
import io.minio.messages.ListPartsResult;
import io.minio.messages.Owner;
import io.minio.messages.Part;
import java.util.List;
import org.springframework.core.convert.converter.Converter;

public class ListPartsResultToDomainConverter
implements Converter<ListPartsResult, ListPartsDomain> {
    private final Converter<Owner, OwnerDomain> owner = new OwnerToDomainConverter();
    private final Converter<Initiator, OwnerDomain> initiator = new InitiatorToDomainConverter();
    private final Converter<List<Part>, List<PartSummaryDomain>> parts = new PartToDomainConverter();
    private final ListPartsArguments arguments;

    public ListPartsResultToDomainConverter(ListPartsArguments arguments) {
        this.arguments = arguments;
    }

    public ListPartsDomain convert(ListPartsResult source) {
        ListPartsDomain domain = new ListPartsDomain();
        domain.setOwner((OwnerDomain)this.owner.convert((Object)source.owner()));
        domain.setInitiator((OwnerDomain)this.initiator.convert((Object)source.initiator()));
        domain.setStorageClass(source.storageClass());
        domain.setMaxParts(Integer.valueOf(source.maxParts()));
        domain.setPartNumberMarker(Integer.valueOf(source.partNumberMarker()));
        domain.setNextPartNumberMarker(Integer.valueOf(source.nextPartNumberMarker()));
        domain.setTruncated(Boolean.valueOf(source.isTruncated()));
        domain.setParts((List)this.parts.convert((Object)source.partList()));
        domain.setUploadId(this.arguments.getUploadId());
        domain.setBucketName(source.bucketName());
        domain.setObjectName(source.objectName());
        return domain;
    }
}

