/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.retention;

import cn.herodotus.engine.assistant.core.utils.type.DateTimeUtils;
import cn.herodotus.oss.dialect.minio.converter.retention.EnumToRetentionModeConverter;
import cn.herodotus.oss.dialect.minio.domain.RetentionDomain;
import cn.herodotus.oss.dialect.minio.enums.RetentionModeEnums;
import io.minio.messages.Retention;
import io.minio.messages.RetentionMode;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;

public class DomainToRetentionConverter
implements Converter<RetentionDomain, Retention> {
    private final Converter<RetentionModeEnums, RetentionMode> toRetentionMode = new EnumToRetentionModeConverter();

    public Retention convert(RetentionDomain retentionDomain) {
        RetentionMode mode = (RetentionMode)this.toRetentionMode.convert((Object)retentionDomain.getMode());
        ZonedDateTime retainUntilDate = DateTimeUtils.stringToZonedDateTime((String)retentionDomain.getRetainUntilDate());
        if (ObjectUtils.isNotEmpty((Object)mode) && ObjectUtils.isNotEmpty((Object)retainUntilDate)) {
            return new Retention(mode, retainUntilDate);
        }
        return null;
    }
}

