/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.repository;

import cn.herodotus.engine.assistant.definition.support.AbstractObjectPool;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToMakeBucketArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToRemoveBucketArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.BucketToDomainConverter;
import cn.herodotus.oss.dialect.minio.definition.service.BaseMinioService;
import cn.herodotus.oss.dialect.minio.service.MinioBucketService;
import cn.herodotus.oss.dialect.minio.utils.ConverterUtils;
import cn.herodotus.oss.specification.arguments.bucket.CreateBucketArguments;
import cn.herodotus.oss.specification.arguments.bucket.DeleteBucketArguments;
import cn.herodotus.oss.specification.core.repository.OssBucketRepository;
import cn.herodotus.oss.specification.domain.bucket.BucketDomain;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.RemoveBucketArgs;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioBucketRepository
extends BaseMinioService
implements OssBucketRepository {
    private static final Logger log = LoggerFactory.getLogger(MinioBucketRepository.class);
    private final MinioBucketService minioBucketService;

    public MinioBucketRepository(AbstractObjectPool<MinioClient> ossClientObjectPool, MinioBucketService minioBucketService) {
        super(ossClientObjectPool);
        this.minioBucketService = minioBucketService;
    }

    public boolean doesBucketExist(String bucketName) {
        return this.minioBucketService.bucketExists(bucketName);
    }

    public List<BucketDomain> listBuckets() {
        return ConverterUtils.toDomains(this.minioBucketService.listBuckets(), new BucketToDomainConverter());
    }

    public BucketDomain createBucket(String bucketName) {
        this.minioBucketService.makeBucket(bucketName);
        return null;
    }

    public BucketDomain createBucket(CreateBucketArguments arguments) {
        ArgumentsToMakeBucketArgsConverter toArgs = new ArgumentsToMakeBucketArgsConverter();
        this.minioBucketService.makeBucket((MakeBucketArgs)toArgs.convert(arguments));
        return null;
    }

    public void deleteBucket(String bucketName) {
        this.minioBucketService.removeBucket(bucketName);
    }

    public void deleteBucket(DeleteBucketArguments arguments) {
        ArgumentsToRemoveBucketArgsConverter toArgs = new ArgumentsToRemoveBucketArgsConverter();
        this.minioBucketService.removeBucket((RemoveBucketArgs)toArgs.convert(arguments));
    }
}

