/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.service;

import cn.herodotus.oss.dialect.core.exception.OssConnectException;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.dialect.core.exception.OssInsufficientDataException;
import cn.herodotus.oss.dialect.core.exception.OssInternalException;
import cn.herodotus.oss.dialect.core.exception.OssInterruptedException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidKeyException;
import cn.herodotus.oss.dialect.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.oss.dialect.core.exception.OssXmlParserException;
import cn.herodotus.oss.dialect.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.oss.dialect.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.dialect.minio.definition.service.BaseMinioAsyncService;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.minio.AbortMultipartUploadResponse;
import io.minio.CreateMultipartUploadResponse;
import io.minio.ListMultipartUploadsResponse;
import io.minio.ListPartsResponse;
import io.minio.ObjectWriteResponse;
import io.minio.UploadPartCopyResponse;
import io.minio.UploadPartResponse;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Part;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioMultipartUploadService
extends BaseMinioAsyncService {
    private static final Logger log = LoggerFactory.getLogger(MinioMultipartUploadService.class);

    public MinioMultipartUploadService(MinioAsyncClientObjectPool minioAsyncClientObjectPool) {
        super(minioAsyncClientObjectPool);
    }

    protected Multimap<String, String> toMultimap(Map<String, String> map) {
        HashMultimap multimap = HashMultimap.create();
        if (map != null) {
            multimap.putAll((Multimap)Multimaps.forMap(map));
        }
        return Multimaps.unmodifiableMultimap((Multimap)multimap);
    }

    public CreateMultipartUploadResponse createMultipartUpload(String bucketName, String objectName) {
        return this.createMultipartUpload(bucketName, null, objectName);
    }

    public CreateMultipartUploadResponse createMultipartUpload(String bucketName, String region, String objectName) {
        return this.createMultipartUpload(bucketName, region, objectName, null, null);
    }

    public CreateMultipartUploadResponse createMultipartUpload(String bucketName, String region, String objectName, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        String function = "createMultipartUpload";
        MinioAsyncClient client = (MinioAsyncClient)((Object)this.getClient());
        try {
            CreateMultipartUploadResponse createMultipartUploadResponse = client.createMultipartUploadAsync(bucketName, region, objectName, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)).get();
            return createMultipartUploadResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close((Object)client);
        }
    }

    public UploadPartResponse uploadPart(String bucketName, String objectName, Object data, long length, String uploadId, int partNumber) {
        return this.uploadPart(bucketName, null, objectName, data, length, uploadId, partNumber);
    }

    public UploadPartResponse uploadPart(String bucketName, String region, String objectName, Object data, long length, String uploadId, int partNumber) {
        return this.uploadPart(bucketName, region, objectName, data, length, uploadId, partNumber, null, null);
    }

    public UploadPartResponse uploadPart(String bucketName, String region, String objectName, Object data, long length, String uploadId, int partNumber, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        String function = "uploadPart";
        MinioAsyncClient client = (MinioAsyncClient)((Object)this.getClient());
        try {
            UploadPartResponse uploadPartResponse = client.uploadPartAsync(bucketName, region, objectName, data, length, uploadId, partNumber, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)).get();
            return uploadPartResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close((Object)client);
        }
    }

    public UploadPartCopyResponse uploadPartCopy(String bucketName, String objectName, String uploadId, int partNumber) {
        return this.uploadPartCopy(bucketName, null, objectName, uploadId, partNumber);
    }

    public UploadPartCopyResponse uploadPartCopy(String bucketName, String region, String objectName, String uploadId, int partNumber) {
        return this.uploadPartCopy(bucketName, region, objectName, uploadId, partNumber, null, null);
    }

    public UploadPartCopyResponse uploadPartCopy(String bucketName, String region, String objectName, String uploadId, int partNumber, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        String function = "uploadPartCopy";
        MinioAsyncClient client = (MinioAsyncClient)((Object)this.getClient());
        try {
            UploadPartCopyResponse uploadPartCopyResponse = client.uploadPartCopyAsync(bucketName, region, objectName, uploadId, partNumber, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)).get();
            return uploadPartCopyResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close((Object)client);
        }
    }

    public AbortMultipartUploadResponse abortMultipartUpload(String bucketName, String objectName, String uploadId) {
        return this.abortMultipartUpload(bucketName, null, objectName, uploadId);
    }

    public AbortMultipartUploadResponse abortMultipartUpload(String bucketName, String region, String objectName, String uploadId) {
        return this.abortMultipartUpload(bucketName, region, objectName, uploadId, null, null);
    }

    public AbortMultipartUploadResponse abortMultipartUpload(String bucketName, String region, String objectName, String uploadId, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        String function = "abortMultipartUpload";
        MinioAsyncClient client = (MinioAsyncClient)((Object)this.getClient());
        try {
            AbortMultipartUploadResponse abortMultipartUploadResponse = client.abortMultipartUploadAsync(bucketName, region, objectName, uploadId, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)).get();
            return abortMultipartUploadResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close((Object)client);
        }
    }

    public ObjectWriteResponse completeMultipartUpload(String bucketName, String objectName, String uploadId, Part[] parts) {
        return this.completeMultipartUpload(bucketName, null, objectName, uploadId, parts);
    }

    public ObjectWriteResponse completeMultipartUpload(String bucketName, String region, String objectName, String uploadId, Part[] parts) {
        return this.completeMultipartUpload(bucketName, region, objectName, uploadId, parts, null, null);
    }

    public ObjectWriteResponse completeMultipartUpload(String bucketName, String region, String objectName, String uploadId, Part[] parts, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        String function = "listParts";
        MinioAsyncClient client = (MinioAsyncClient)((Object)this.getClient());
        try {
            ObjectWriteResponse objectWriteResponse = client.completeMultipartUploadAsync(bucketName, region, objectName, uploadId, parts, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)).get();
            return objectWriteResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close((Object)client);
        }
    }

    public ListPartsResponse listParts(String bucketName, String objectName, String uploadId) {
        return this.listParts(bucketName, objectName, null, uploadId);
    }

    public ListPartsResponse listParts(String bucketName, String objectName, Integer partNumberMarker, String uploadId) {
        return this.listParts(bucketName, objectName, null, partNumberMarker, uploadId);
    }

    public ListPartsResponse listParts(String bucketName, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId) {
        return this.listParts(bucketName, null, objectName, maxParts, partNumberMarker, uploadId);
    }

    public ListPartsResponse listParts(String bucketName, String region, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId) {
        return this.listParts(bucketName, region, objectName, maxParts, partNumberMarker, uploadId, null, null);
    }

    public ListPartsResponse listParts(String bucketName, String region, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        String function = "listParts";
        MinioAsyncClient client = (MinioAsyncClient)((Object)this.getClient());
        try {
            ListPartsResponse listPartsResponse = client.listPartsAsync(bucketName, region, objectName, maxParts, partNumberMarker, uploadId, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)).get();
            return listPartsResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close((Object)client);
        }
    }

    public ListMultipartUploadsResponse listMultipartUploads(String bucketName, String delimiter, Integer maxUploads, String prefix) {
        return this.listMultipartUploads(bucketName, delimiter, null, maxUploads, prefix, null);
    }

    public ListMultipartUploadsResponse listMultipartUploads(String bucketName) {
        return this.listMultipartUploads(bucketName, null);
    }

    public ListMultipartUploadsResponse listMultipartUploads(String bucketName, String prefix) {
        return this.listMultipartUploads(bucketName, "/", prefix);
    }

    public ListMultipartUploadsResponse listMultipartUploads(String bucketName, String delimiter, String prefix) {
        return this.listMultipartUploads(bucketName, delimiter, null, prefix);
    }

    public ListMultipartUploadsResponse listMultipartUploads(String bucketName, String delimiter, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) {
        return this.listMultipartUploads(bucketName, delimiter, null, keyMarker, maxUploads, prefix, uploadIdMarker);
    }

    public ListMultipartUploadsResponse listMultipartUploads(String bucketName, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) {
        return this.listMultipartUploads(bucketName, null, delimiter, encodingType, keyMarker, maxUploads, prefix, uploadIdMarker);
    }

    public ListMultipartUploadsResponse listMultipartUploads(String bucketName, String region, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) {
        return this.listMultipartUploads(bucketName, region, delimiter, encodingType, keyMarker, maxUploads, prefix, uploadIdMarker, null, null);
    }

    public ListMultipartUploadsResponse listMultipartUploads(String bucketName, String region, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker, Map<String, String> extraHeaders, Map<String, String> extraQueryParams) {
        String function = "listMultipartUploads";
        MinioAsyncClient client = (MinioAsyncClient)((Object)this.getClient());
        try {
            ListMultipartUploadsResponse listMultipartUploadsResponse = client.listMultipartUploadsAsync(bucketName, region, delimiter, encodingType, keyMarker, maxUploads, prefix, uploadIdMarker, this.toMultimap(extraHeaders), this.toMultimap(extraQueryParams)).get();
            return listMultipartUploadsResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close((Object)client);
        }
    }
}

