/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.controller;

import cn.hippo4j.adapter.web.WebThreadPoolHandlerChoose;
import cn.hippo4j.adapter.web.WebThreadPoolService;
import cn.hippo4j.common.model.ThreadPoolBaseInfo;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.common.web.base.Results;
import lombok.Generated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
public class WebThreadPoolController {
    private final WebThreadPoolHandlerChoose webThreadPoolServiceChoose;

    @GetMapping(value={"/web/base/info"})
    public Result<ThreadPoolBaseInfo> getPoolBaseState(@RequestParam(value="mark") String mark) {
        WebThreadPoolService webThreadPoolService = this.webThreadPoolServiceChoose.choose();
        if (webThreadPoolService != null && webThreadPoolService.getClass().getSimpleName().contains(mark)) {
            return Results.success((Object)webThreadPoolService.simpleInfo());
        }
        return Results.success(null);
    }

    @GetMapping(value={"/web/run/state"})
    public Result<ThreadPoolRunStateInfo> getPoolRunState() {
        ThreadPoolRunStateInfo result = this.webThreadPoolServiceChoose.choose().getWebRunStateInfo();
        return Results.success((Object)result);
    }

    @PostMapping(value={"/web/update/pool"})
    public Result<Void> updateWebThreadPool(@RequestBody ThreadPoolParameterInfo threadPoolParameterInfo) {
        this.webThreadPoolServiceChoose.choose().updateWebThreadPool(threadPoolParameterInfo);
        return Results.success();
    }

    @Generated
    public WebThreadPoolController(WebThreadPoolHandlerChoose webThreadPoolServiceChoose) {
        this.webThreadPoolServiceChoose = webThreadPoolServiceChoose;
    }
}

