/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.support;

import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.core.plugin.ThreadPoolPlugin;
import cn.hippo4j.core.plugin.manager.DefaultGlobalThreadPoolPluginManager;
import cn.hippo4j.core.plugin.manager.ThreadPoolPluginRegistrar;
import cn.hippo4j.core.plugin.manager.ThreadPoolPluginSupport;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ThreadPoolPluginRegisterPostProcessor
extends DefaultGlobalThreadPoolPluginManager
implements BeanPostProcessor,
ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolPluginRegisterPostProcessor.class);
    private ConfigurableListableBeanFactory beanFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanType;
        block4: {
            beanType = null;
            try {
                beanType = AutoProxyUtils.determineTargetClass((ConfigurableListableBeanFactory)this.beanFactory, (String)beanName);
            }
            catch (NoSuchBeanDefinitionException ex) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Could not resolve target class for bean with name '" + beanName + "'", (Throwable)ex);
            }
        }
        if (Objects.isNull(beanType)) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot resolve type for bean [{}]", (Object)beanName);
            }
            return bean;
        }
        this.registerThreadPoolPluginRegistrarIfNecessary(bean, beanType);
        this.registerThreadPoolPluginIfNecessary(bean, beanType);
        this.registerThreadPoolPluginSupportIfNecessary(bean, beanType);
        return bean;
    }

    private void registerThreadPoolPluginSupportIfNecessary(Object bean, Class<?> beanType) {
        ThreadPoolPluginSupport support;
        if (ThreadPoolPluginSupport.class.isAssignableFrom(beanType) && this.registerThreadPoolPluginSupport(support = (ThreadPoolPluginSupport)bean) && log.isDebugEnabled()) {
            log.debug("Register ThreadPoolPluginSupport [{}]", (Object)support.getThreadPoolId());
        }
    }

    private void registerThreadPoolPluginIfNecessary(Object bean, Class<?> beanType) {
        ThreadPoolPlugin plugin;
        if (ThreadPoolPlugin.class.isAssignableFrom(beanType) && this.enableThreadPoolPlugin(plugin = (ThreadPoolPlugin)bean) && log.isDebugEnabled()) {
            log.debug("Register ThreadPoolPlugin [{}]", (Object)plugin.getId());
        }
    }

    private void registerThreadPoolPluginRegistrarIfNecessary(Object bean, Class<?> beanType) {
        ThreadPoolPluginRegistrar registrar;
        if (ThreadPoolPluginRegistrar.class.isAssignableFrom(beanType) && this.enableThreadPoolPluginRegistrar(registrar = (ThreadPoolPluginRegistrar)bean) && log.isDebugEnabled()) {
            log.debug("Register ThreadPoolPluginRegistrar [{}]", (Object)registrar.getId());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        AutowireCapableBeanFactory factory = applicationContext.getAutowireCapableBeanFactory();
        Assert.isTrue((boolean)(factory instanceof ConfigurableListableBeanFactory), (String)"Factory cannot cast to ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)factory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

