/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.toolkit;

import cn.hippo4j.core.toolkit.inet.InetUtils;
import org.springframework.core.env.PropertyResolver;

public class CloudCommonIdUtil {
    private static final String SEPARATOR = ":";

    public static String getClientIpPort(PropertyResolver resolver, InetUtils inetUtils) {
        String hostname = inetUtils.findFirstNonLoopBackHostInfo().getIpAddress();
        String port = resolver.getProperty("server.port", "8080");
        return CloudCommonIdUtil.combineParts(hostname, SEPARATOR, port);
    }

    public static String getDefaultInstanceId(PropertyResolver resolver, InetUtils inetUtils) {
        String namePart = CloudCommonIdUtil.getIpApplicationName(resolver, inetUtils);
        String indexPart = resolver.getProperty("spring.application.instance_id", resolver.getProperty("server.port"));
        return CloudCommonIdUtil.combineParts(namePart, SEPARATOR, indexPart);
    }

    public static String getIpApplicationName(PropertyResolver resolver, InetUtils inetUtils) {
        String hostname = inetUtils.findFirstNonLoopBackHostInfo().getIpAddress();
        String appName = resolver.getProperty("spring.application.name");
        return CloudCommonIdUtil.combineParts(hostname, SEPARATOR, appName);
    }

    public static String combineParts(String firstPart, String separator, String secondPart) {
        String combined = null;
        if (firstPart != null && secondPart != null) {
            combined = firstPart + separator + secondPart;
        } else if (firstPart != null) {
            combined = firstPart;
        } else if (secondPart != null) {
            combined = secondPart;
        }
        return combined;
    }
}

