/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha;

import cn.hutool.captcha.ICaptcha;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ImageUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractCaptcha
implements ICaptcha {
    private static final long serialVersionUID = 3180820918087507254L;
    protected int width = 100;
    protected int height = 37;
    protected int codeCount = 4;
    protected int interfereCount = 15;
    protected Font font;
    protected String code;
    protected byte[] imageBytes;

    public AbstractCaptcha(int width, int height, int codeCount, int interfereCount) {
        this.width = width;
        this.height = height;
        this.codeCount = codeCount;
        this.interfereCount = interfereCount;
        this.font = new Font("Courier", 0, this.height - 2);
        this.createCode();
    }

    @Override
    public void createCode() {
        this.generateCode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.writePng(this.createImage(this.code), out);
        this.imageBytes = out.toByteArray();
    }

    protected void generateCode() {
        this.code = RandomUtil.randomString(this.codeCount);
    }

    protected abstract Image createImage(String var1);

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public boolean verify(String userInputCode) {
        if (StrUtil.isNotBlank(userInputCode)) {
            return StrUtil.equalsIgnoreCase(this.getCode(), userInputCode);
        }
        return false;
    }

    public void write(String path) throws IORuntimeException {
        this.write(FileUtil.touch(path));
    }

    public void write(File file) throws IORuntimeException {
        try (BufferedOutputStream out = FileUtil.getOutputStream(file);){
            this.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void write(OutputStream out) {
        IoUtil.write(out, false, this.imageBytes);
    }

    public BufferedImage getImage() {
        if (null == this.imageBytes) {
            this.createCode();
        }
        return ImageUtil.read(new ByteArrayInputStream(this.imageBytes));
    }

    public String getImageBase64() {
        return Base64.encode(this.imageBytes);
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

