/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.cron.Scheduler;
import cn.hutool.cron.TaskLauncher;
import java.util.ArrayList;
import java.util.List;

public class TaskLauncherManager {
    protected Scheduler scheduler;
    protected List<TaskLauncher> launchers = new ArrayList<TaskLauncher>();

    public TaskLauncherManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskLauncher spawnLauncher(long millis) {
        TaskLauncher launcher = new TaskLauncher(this.scheduler, millis);
        List<TaskLauncher> list = this.launchers;
        synchronized (list) {
            this.launchers.add(launcher);
        }
        launcher.setDaemon(this.scheduler.daemon);
        launcher.start();
        return launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLauncherCompleted(TaskLauncher launcher) {
        List<TaskLauncher> list = this.launchers;
        synchronized (list) {
            this.launchers.remove(launcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskLauncherManager destroy() {
        List<TaskLauncher> list = this.launchers;
        synchronized (list) {
            for (TaskLauncher taskLauncher : this.launchers) {
                ThreadUtil.interupt(taskLauncher, true);
            }
        }
        this.launchers.clear();
        return this;
    }
}

