/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.hikari;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.dialect.DriverUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.setting.Setting;
import cn.hutool.setting.dialect.Props;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class HikariDSFactory
extends DSFactory {
    public static final String DS_NAME = "HikariCP";
    private Map<String, HikariDataSource> dsMap = new ConcurrentHashMap<String, HikariDataSource>();

    public HikariDSFactory() {
        this(null);
    }

    public HikariDSFactory(Setting setting) {
        super(DS_NAME, HikariDataSource.class, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        HikariDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        HikariDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        HikariDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoUtil.close((Closeable)ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<HikariDataSource> values = this.dsMap.values();
            for (HikariDataSource ds : values) {
                IoUtil.close((Closeable)ds);
            }
            this.dsMap.clear();
        }
    }

    private HikariDataSource createDataSource(String group) {
        String pass;
        String user;
        Props config;
        if (group == null) {
            group = "";
        }
        if (CollectionUtil.isEmpty(config = this.setting.getProps(group))) {
            throw new DbRuntimeException("No HikariCP config for group: [{}]", group);
        }
        String url = config.getAndRemoveStr(KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        config.put("jdbcUrl", url);
        String driver = config.getAndRemoveStr(KEY_ALIAS_DRIVER);
        if (StrUtil.isBlank(driver)) {
            driver = DriverUtil.identifyDriver(url);
        }
        if (null != driver) {
            config.put("driverClassName", driver);
        }
        if (null != (user = config.getAndRemoveStr(KEY_ALIAS_USER))) {
            config.put("username", user);
        }
        if (null != (pass = config.getAndRemoveStr(KEY_ALIAS_PASSWORD))) {
            config.put("password", pass);
        }
        HikariDataSource ds = new HikariDataSource(new HikariConfig((Properties)config));
        return ds;
    }
}

