/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.comparator.VersionComparator;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Func1;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.text.TextSimilarity;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class StrUtil {
    public static final int INDEX_NOT_FOUND = -1;
    public static final char C_SPACE = ' ';
    public static final char C_TAB = '\t';
    public static final char C_DOT = '.';
    public static final char C_SLASH = '/';
    public static final char C_BACKSLASH = '\\';
    public static final char C_CR = '\r';
    public static final char C_LF = '\n';
    public static final char C_UNDERLINE = '_';
    public static final char C_COMMA = ',';
    public static final char C_DELIM_START = '{';
    public static final char C_DELIM_END = '}';
    public static final char C_BRACKET_START = '[';
    public static final char C_BRACKET_END = ']';
    public static final char C_COLON = ':';
    public static final String SPACE = " ";
    public static final String TAB = "\t";
    public static final String DOT = ".";
    public static final String DOUBLE_DOT = "..";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final String UNDERLINE = "_";
    public static final String DASHED = "-";
    public static final String COMMA = ",";
    public static final String DELIM_START = "{";
    public static final String DELIM_END = "}";
    public static final String BRACKET_START = "[";
    public static final String BRACKET_END = "]";
    public static final String COLON = ":";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp;";
    public static final String HTML_QUOTE = "&quot;";
    public static final String HTML_APOS = "&apos;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String EMPTY_JSON = "{}";

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtil.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isNotBlank(CharSequence str) {
        return false == StrUtil.isBlank(str);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmptyIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return false == StrUtil.isEmpty(str);
    }

    public static String nullToEmpty(CharSequence str) {
        return StrUtil.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String emptyToDefault(CharSequence str, String defaultStr) {
        return StrUtil.isEmpty(str) ? defaultStr : str.toString();
    }

    public static String blankToDefault(CharSequence str, String defaultStr) {
        return StrUtil.isBlank(str) ? defaultStr : str.toString();
    }

    public static String emptyToNull(CharSequence str) {
        return StrUtil.isEmpty(str) ? null : str.toString();
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrUndefined(CharSequence str) {
        if (null == str) {
            return true;
        }
        return StrUtil.isNullOrUndefinedStr(str);
    }

    public static boolean isEmptyOrUndefined(CharSequence str) {
        if (StrUtil.isEmpty(str)) {
            return true;
        }
        return StrUtil.isNullOrUndefinedStr(str);
    }

    public static boolean isBlankOrUndefined(CharSequence str) {
        if (StrUtil.isBlank(str)) {
            return true;
        }
        return StrUtil.isNullOrUndefinedStr(str);
    }

    private static boolean isNullOrUndefinedStr(CharSequence str) {
        String strString = str.toString().trim();
        return "null".equals(strString) || "undefined".equals(strString);
    }

    public static String trim(CharSequence str) {
        return null == str ? null : StrUtil.trim(str, 0);
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = str.trim();
        }
    }

    public static String trimToEmpty(CharSequence str) {
        return str == null ? EMPTY : StrUtil.trim(str);
    }

    public static String trimToNull(CharSequence str) {
        String trimStr = StrUtil.trim(str);
        return EMPTY.equals(trimStr) ? null : trimStr;
    }

    public static String trimStart(CharSequence str) {
        return StrUtil.trim(str, -1);
    }

    public static String trimEnd(CharSequence str) {
        return StrUtil.trim(str, 1);
    }

    public static String trim(CharSequence str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && CharUtil.isBlankChar(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && CharUtil.isBlankChar(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.toString().substring(start, end);
        }
        return str.toString();
    }

    public static boolean startWith(CharSequence str, char c) {
        return c == str.charAt(0);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean isIgnoreCase) {
        if (null == str || null == prefix) {
            return null == str && null == prefix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().startsWith(prefix.toString().toLowerCase());
        }
        return str.toString().startsWith(prefix.toString());
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return StrUtil.startWith(str, prefix, false);
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StrUtil.startWith(str, prefix, true);
    }

    public static boolean startWithAny(CharSequence str, CharSequence ... prefixes) {
        if (StrUtil.isEmpty(str) || ArrayUtil.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence suffix : prefixes) {
            if (!StrUtil.startWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence str, char c) {
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean isIgnoreCase) {
        if (null == str || null == suffix) {
            return null == str && null == suffix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return str.toString().endsWith(suffix.toString());
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return StrUtil.endWith(str, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StrUtil.endWith(str, suffix, true);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        if (StrUtil.isEmpty(str) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!StrUtil.endWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return StrUtil.indexOf(str, searchChar) > -1;
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StrUtil.getContainsStr(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!StrUtil.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayUtil.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsBlank(CharSequence str) {
        if (null == str) {
            return false;
        }
        int length = str.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharUtil.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (StrUtil.isEmpty(str) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != StrUtil.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (StrUtil.isEmpty(str) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!StrUtil.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static String getGeneralField(CharSequence getOrSetMethodName) {
        String getOrSetMethodNameStr = getOrSetMethodName.toString();
        if (getOrSetMethodNameStr.startsWith("get") || getOrSetMethodNameStr.startsWith("set")) {
            return StrUtil.removePreAndLowerFirst(getOrSetMethodName, 3);
        }
        return null;
    }

    public static String genSetter(CharSequence fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(CharSequence fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, "get");
    }

    public static String removeAll(CharSequence str, CharSequence strToRemove) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        return str.toString().replace(strToRemove, EMPTY);
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (null == str || ArrayUtil.isEmpty(chars)) {
            return StrUtil.str(str);
        }
        int len = str.length();
        if (0 == len) {
            return StrUtil.str(str);
        }
        StringBuilder builder = StrUtil.builder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (ArrayUtil.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removeAllLineBreaks(CharSequence str) {
        return StrUtil.removeAll(str, '\r', '\n');
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePreAndLowerFirst(CharSequence str, CharSequence prefix) {
        return StrUtil.lowerFirst(StrUtil.removePrefix(str, prefix));
    }

    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + StrUtil.upperFirst(str);
    }

    public static String upperFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + StrUtil.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String lowerFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isUpperCase(firstChar = str.charAt(0))) {
            return Character.toLowerCase(firstChar) + StrUtil.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return StrUtil.str(str);
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return StrUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return StrUtil.str(str);
        }
        String str2 = str.toString();
        if (str2.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            return StrUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(suffix)) {
            return StrUtil.str(str);
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return StrUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String removeSufAndLowerFirst(CharSequence str, CharSequence suffix) {
        return StrUtil.lowerFirst(StrUtil.removeSuffix(str, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence str, CharSequence suffix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(suffix)) {
            return StrUtil.str(str);
        }
        String str2 = str.toString();
        if (str2.toLowerCase().endsWith(suffix.toString().toLowerCase())) {
            return StrUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String strip(CharSequence str, CharSequence prefixOrSuffix) {
        return StrUtil.strip(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (StrUtil.startWith((CharSequence)str2, prefix)) {
            from = prefix.length();
        }
        if (StrUtil.endWith((CharSequence)str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefixOrSuffix) {
        return StrUtil.stripIgnoreCase(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (StrUtil.startWithIgnoreCase(str2, prefix)) {
            from = prefix.length();
        }
        if (StrUtil.endWithIgnoreCase(str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        String prefix2;
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return StrUtil.str(str);
        }
        String str2 = str.toString();
        if (!str2.startsWith(prefix2 = prefix.toString())) {
            return prefix2.concat(str2);
        }
        return str2;
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        String suffix2;
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(suffix)) {
            return StrUtil.str(str);
        }
        String str2 = str.toString();
        if (!str2.endsWith(suffix2 = suffix.toString())) {
            return str2.concat(suffix2);
        }
        return str2;
    }

    public static String cleanBlank(CharSequence str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (CharUtil.isBlankChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] splitToArray(CharSequence str, char separator) {
        return StrUtil.splitToArray(str, separator, 0);
    }

    public static long[] splitToLong(CharSequence str, char separator) {
        return Convert.convert(long[].class, StrUtil.splitTrim(str, separator));
    }

    public static long[] splitToLong(CharSequence str, CharSequence separator) {
        return Convert.convert(long[].class, StrUtil.splitTrim(str, separator));
    }

    public static int[] splitToInt(CharSequence str, char separator) {
        return Convert.convert(int[].class, StrUtil.splitTrim(str, separator));
    }

    public static int[] splitToInt(CharSequence str, CharSequence separator) {
        return Convert.convert(int[].class, StrUtil.splitTrim(str, separator));
    }

    public static List<String> split(CharSequence str, char separator) {
        return StrUtil.split(str, separator, 0);
    }

    public static String[] splitToArray(CharSequence str, char separator, int limit) {
        if (null == str) {
            return new String[0];
        }
        return StrSpliter.splitToArray(str.toString(), separator, limit, false, false);
    }

    public static List<String> split(CharSequence str, char separator, int limit) {
        return StrUtil.split(str, separator, limit, false, false);
    }

    public static List<String> splitTrim(CharSequence str, char separator) {
        return StrUtil.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        return StrUtil.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, char separator, int limit) {
        return StrUtil.split(str, separator, limit, true, true);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator, int limit) {
        return StrUtil.split(str, separator, limit, true, true);
    }

    public static List<String> split(CharSequence str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StrUtil.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        return StrSpliter.split(str.toString(), separator, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StrSpliter.split(str.toString(), separatorStr, limit, isTrim, ignoreEmpty);
    }

    public static String[] split(CharSequence str, CharSequence separator) {
        if (str == null) {
            return new String[0];
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StrSpliter.splitToArray(str.toString(), separatorStr, 0, false, false);
    }

    public static String[] split(CharSequence str, int len) {
        if (null == str) {
            return new String[0];
        }
        return StrSpliter.splitByLength(str.toString(), len);
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        return str.toString().substring(fromIndex, toIndex);
    }

    public static String subPreGbk(CharSequence str, int len, CharSequence suffix) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int counterOfDoubleByte = 0;
        byte[] b = str.toString().getBytes(CharsetUtil.CHARSET_GBK);
        if (b.length <= len) {
            return str.toString();
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] >= 0) continue;
            ++counterOfDoubleByte;
        }
        if (counterOfDoubleByte % 2 != 0) {
            ++len;
        }
        return new String(b, 0, len, CharsetUtil.CHARSET_GBK) + suffix;
    }

    public static String maxLength(CharSequence string, int length) {
        Assert.isTrue(length > 0);
        if (null == string) {
            return null;
        }
        if (string.length() <= length) {
            return string.toString();
        }
        return StrUtil.sub(string, 0, length) + "...";
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StrUtil.sub(string, 0, toIndex);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (StrUtil.isEmpty(string)) {
            return null;
        }
        return StrUtil.sub(string, fromIndex, string.length());
    }

    public static String subSufByLength(CharSequence string, int length) {
        if (StrUtil.isEmpty(string)) {
            return null;
        }
        if (length <= 0) {
            return EMPTY;
        }
        return StrUtil.sub(string, -length, string.length());
    }

    public static String subWithLength(String input, int fromIndex, int length) {
        return StrUtil.sub(input, fromIndex, fromIndex + length);
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StrUtil.isEmpty(string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return EMPTY;
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StrUtil.isEmpty(string)) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StrUtil.isEmpty(string)) {
            return null == string ? null : string.toString();
        }
        if (separator == null) {
            return EMPTY;
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StrUtil.isEmpty(string)) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return EMPTY;
        }
        return str.substring(pos + 1);
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return StrUtil.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static boolean isSurround(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix.toString()) && str2.endsWith(suffix.toString());
    }

    public static boolean isSurround(CharSequence str, char prefix, char suffix) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return EMPTY;
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(CharSequence str, int count) {
        int n;
        if (null == str) {
            return null;
        }
        if (count <= 0) {
            return EMPTY;
        }
        if (count == 1 || str.length() == 0) {
            return str.toString();
        }
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String repeatByLength(CharSequence str, int padLen) {
        if (null == str) {
            return null;
        }
        if (padLen <= 0) {
            return EMPTY;
        }
        int strLen = str.length();
        if (strLen == padLen) {
            return str.toString();
        }
        if (strLen > padLen) {
            return StrUtil.subPre(str, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = str.charAt(i % padLen);
        }
        return new String(padding);
    }

    public static String repeatAndJoin(CharSequence str, int count, CharSequence conjunction) {
        if (count <= 0) {
            return EMPTY;
        }
        StrBuilder builder = StrBuilder.create();
        boolean isFirst = true;
        while (count-- > 0) {
            if (isFirst) {
                isFirst = false;
            } else if (StrUtil.isNotEmpty(conjunction)) {
                builder.append(conjunction);
            }
            builder.append(str);
        }
        return builder.toString();
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return StrUtil.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return StrUtil.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.equals(str2);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence str1, CharSequence ... strs) {
        return StrUtil.equalsAny(str1, true, strs);
    }

    public static boolean equalsAny(CharSequence str1, CharSequence ... strs) {
        return StrUtil.equalsAny(str1, false, strs);
    }

    public static boolean equalsAny(CharSequence str1, boolean ignoreCase, CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return false;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.equals(str1, str, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return null;
        }
        if (ArrayUtil.isEmpty(params) || StrUtil.isBlank(template)) {
            return template.toString();
        }
        return StrFormatter.format(template.toString(), params);
    }

    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        return MessageFormat.format(pattern.toString(), arguments);
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        if (null == template) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return template.toString();
        }
        String template2 = template.toString();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String value = StrUtil.utf8Str(entry.getValue());
            if (null == value) continue;
            template2 = StrUtil.replace((CharSequence)template2, (CharSequence)(DELIM_START + entry.getKey() + DELIM_END), value);
        }
        return template2;
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return StrUtil.bytes(str, CharsetUtil.CHARSET_UTF_8);
    }

    public static byte[] bytes(CharSequence str) {
        return StrUtil.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return StrUtil.bytes(str, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, CharsetUtil.CHARSET_UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return StrUtil.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtil.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StrUtil.str(bytes, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StrUtil.str(bytes, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StrUtil.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StrUtil.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String toString(Object obj) {
        return null == obj ? "null" : obj.toString();
    }

    public static ByteBuffer byteBuffer(CharSequence str, String charset) {
        return ByteBuffer.wrap(StrUtil.bytes(str, charset));
    }

    public static String join(CharSequence conjunction, Object ... objs) {
        return ArrayUtil.join(objs, conjunction);
    }

    public static String toUnderlineCase(CharSequence str) {
        return StrUtil.toSymbolCase(str, '_');
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            Character preChar;
            char c = str.charAt(i);
            Character c2 = preChar = i > 0 ? Character.valueOf(str.charAt(i - 1)) : null;
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character c3 = nextChar = i < str.length() - 1 ? Character.valueOf(str.charAt(i + 1)) : null;
                if (null != preChar && Character.isUpperCase(preChar.charValue())) {
                    sb.append(c);
                    continue;
                }
                if (null != nextChar && Character.isUpperCase(nextChar.charValue())) {
                    if (null != preChar && symbol != preChar.charValue()) {
                        sb.append(symbol);
                    }
                    sb.append(c);
                    continue;
                }
                if (null != preChar && symbol != preChar.charValue()) {
                    sb.append(symbol);
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (sb.length() > 0 && Character.isUpperCase(sb.charAt(sb.length() - 1)) && symbol != c) {
                sb.append(symbol);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCamelCase(CharSequence name) {
        if (null == name) {
            return null;
        }
        String name2 = name.toString();
        if (name2.contains(UNDERLINE)) {
            StringBuilder sb = new StringBuilder(name2.length());
            boolean upperCase = false;
            for (int i = 0; i < name2.length(); ++i) {
                char c = name2.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(Character.toLowerCase(c));
            }
            return sb.toString();
        }
        return name2;
    }

    public static String wrap(CharSequence str, CharSequence prefixAndSuffix) {
        return StrUtil.wrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return StrUtil.nullToEmpty(prefix).concat(StrUtil.nullToEmpty(str)).concat(StrUtil.nullToEmpty(suffix));
    }

    public static String[] wrapAll(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return StrUtil.wrapAll(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = StrUtil.wrap(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String wrapIfMissing(CharSequence str, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (StrUtil.isNotEmpty(str)) {
            len += str.length();
        }
        if (StrUtil.isNotEmpty(prefix)) {
            len += str.length();
        }
        if (StrUtil.isNotEmpty(suffix)) {
            len += str.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (StrUtil.isNotEmpty(prefix) && !StrUtil.startWith(str, prefix)) {
            sb.append(prefix);
        }
        if (StrUtil.isNotEmpty(str)) {
            sb.append(str);
        }
        if (StrUtil.isNotEmpty(suffix) && !StrUtil.endWith(str, suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String[] wrapAllIfMissing(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return StrUtil.wrapAllIfMissing(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = StrUtil.wrapIfMissing(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence str, String prefix, String suffix) {
        if (StrUtil.isWrap(str, prefix, suffix)) {
            return StrUtil.sub(str, prefix.length(), str.length() - suffix.length());
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefix, char suffix) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        if (str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix) {
            return StrUtil.sub(str, 1, str.length() - 1);
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefixAndSuffix) {
        return StrUtil.unWrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence str, String prefix, String suffix) {
        if (ArrayUtil.hasNull(str, prefix, suffix)) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix) && str2.endsWith(suffix);
    }

    public static boolean isWrap(CharSequence str, String wrapper) {
        return StrUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char wrapper) {
        return StrUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static String padPre(CharSequence str, int minLength, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StrUtil.subPre(str, minLength);
        }
        return StrUtil.repeat(padStr, minLength - strLen).concat(str.toString());
    }

    public static String padPre(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StrUtil.subPre(str, minLength);
        }
        return StrUtil.repeat(padChar, minLength - strLen).concat(str.toString());
    }

    public static String padAfter(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StrUtil.sub(str, strLen - minLength, strLen);
        }
        return str.toString().concat(StrUtil.repeat(padChar, minLength - strLen));
    }

    public static String padAfter(CharSequence str, int minLength, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StrUtil.subSuf(str, minLength);
        }
        return str.toString().concat(StrUtil.repeat(padStr, minLength - strLen));
    }

    public static String center(CharSequence str, int size) {
        return StrUtil.center(str, size, ' ');
    }

    public static String center(CharSequence str, int size, char padChar) {
        if (str == null || size <= 0) {
            return StrUtil.str(str);
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str.toString();
        }
        str = StrUtil.padPre(str, strLen + pads / 2, padChar);
        str = StrUtil.padAfter(str, size, padChar);
        return str.toString();
    }

    public static String center(CharSequence str, int size, CharSequence padStr) {
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return StrUtil.str(str);
        }
        if (StrUtil.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str.toString();
        }
        str = StrUtil.padPre(str, strLen + pads / 2, padStr);
        str = StrUtil.padAfter(str, size, padStr);
        return str.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StrBuilder strBuilder() {
        return StrBuilder.create();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StrBuilder strBuilder(int capacity) {
        return StrBuilder.create(capacity);
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StrBuilder strBuilder(CharSequence ... strs) {
        return StrBuilder.create(strs);
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (StrUtil.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (StrUtil.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String[] cut(CharSequence str, int partLength) {
        if (null == str) {
            return null;
        }
        int len = str.length();
        if (len < partLength) {
            return new String[]{str.toString()};
        }
        int part = NumberUtil.count(len, partLength);
        String[] array = new String[part];
        String str2 = str.toString();
        for (int i = 0; i < part; ++i) {
            array[i] = str2.substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array;
    }

    public static String brief(CharSequence str, int maxLength) {
        if (null == str) {
            return null;
        }
        if (str.length() + 3 <= maxLength) {
            return str.toString();
        }
        int w = maxLength / 2;
        int l = str.length();
        String str2 = str.toString();
        return StrUtil.format((CharSequence)"{}...{}", str2.substring(0, maxLength - w), str2.substring(l - w));
    }

    public static int compare(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareTo(str2.toString());
    }

    public static int compareIgnoreCase(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareToIgnoreCase(str2.toString());
    }

    public static int compareVersion(CharSequence version1, CharSequence version2) {
        return VersionComparator.INSTANCE.compare(StrUtil.str(version1), StrUtil.str(version2));
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return StrUtil.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return StrUtil.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StrUtil.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StrUtil.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!StrUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StrUtil.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StrUtil.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, str.length());
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().lastIndexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i > 0; --i) {
            if (!StrUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String str, String searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = str.indexOf(searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return StrUtil.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return StrUtil.appendIfMissing(str, suffix, true, suffixes);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... suffixes) {
        if (str == null || StrUtil.isEmpty(suffix) || StrUtil.endWith(str, suffix, ignoreCase)) {
            return StrUtil.str(str);
        }
        if (suffixes != null && suffixes.length > 0) {
            for (CharSequence s : suffixes) {
                if (!StrUtil.endWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return str.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return StrUtil.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return StrUtil.prependIfMissing(str, prefix, true, prefixes);
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || StrUtil.isEmpty(prefix) || StrUtil.startWith(str, prefix, ignoreCase)) {
            return StrUtil.str(str);
        }
        if (prefixes != null && prefixes.length > 0) {
            for (CharSequence s : prefixes) {
                if (!StrUtil.startWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return prefix.toString().concat(str.toString());
    }

    public static String reverse(String str) {
        return new String(ArrayUtil.reverse(str.toCharArray()));
    }

    public static String fillBefore(String str, char filledChar, int len) {
        return StrUtil.fill(str, filledChar, len, true);
    }

    public static String fillAfter(String str, char filledChar, int len) {
        return StrUtil.fill(str, filledChar, len, false);
    }

    public static String fill(String str, char filledChar, int len, boolean isPre) {
        int strLen = str.length();
        if (strLen > len) {
            return str;
        }
        String filledStr = StrUtil.repeat(filledChar, len - strLen);
        return isPre ? filledStr.concat(str) : str.concat(filledStr);
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static boolean isAllCharMatch(CharSequence value, Matcher<Character> matcher) {
        if (StrUtil.isBlank(value)) {
            return false;
        }
        int len = value.length();
        boolean isAllMatch = true;
        for (int i = 0; i < len; ++i) {
            isAllMatch &= matcher.match(Character.valueOf(value.charAt(i)));
        }
        return isAllMatch;
    }

    public static String replaceIgnoreCase(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return StrUtil.replace(str, 0, searchStr, replacement, true);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return StrUtil.replace(str, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        return StrUtil.replace(str, 0, searchStr, replacement, ignoreCase);
    }

    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(searchStr)) {
            return StrUtil.str(str);
        }
        if (null == replacement) {
            replacement = EMPTY;
        }
        int strLength = str.length();
        int searchStrLength = searchStr.length();
        if (fromIndex > strLength) {
            return StrUtil.str(str);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        StrBuilder result = StrBuilder.create(strLength + 16);
        if (0 != fromIndex) {
            result.append(str.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        int index = fromIndex;
        while ((index = StrUtil.indexOf(str, searchStr, preIndex, ignoreCase)) > -1) {
            result.append(str.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + searchStrLength;
        }
        if (preIndex < strLength) {
            result.append(str.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return StrUtil.str(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return StrUtil.str(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static String replace(CharSequence str, Pattern pattern, Func1<java.util.regex.Matcher, String> replaceFun) {
        return ReUtil.replaceAll(str, pattern, replaceFun);
    }

    public static String replace(CharSequence str, String regex, Func1<java.util.regex.Matcher, String> replaceFun) {
        return ReUtil.replaceAll(str, regex, replaceFun);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return StrUtil.replace(str, startInclude, endExclude, '*');
    }

    public static String replaceChars(CharSequence str, String chars, CharSequence replacedStr) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(chars)) {
            return StrUtil.str(str);
        }
        return StrUtil.replaceChars(str, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence str, char[] chars, CharSequence replacedStr) {
        if (StrUtil.isEmpty(str) || ArrayUtil.isEmpty(chars)) {
            return StrUtil.str(str);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = str.length();
        StringBuilder builder = StrUtil.builder();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static double similar(String str1, String str2) {
        return TextSimilarity.similar(str1, str2);
    }

    public static String similar(String str1, String str2, int scale) {
        return TextSimilarity.similar(str1, str2, scale);
    }

    public static boolean equalsCharAt(CharSequence str, int position, char c) {
        if (null == str || position < 0) {
            return false;
        }
        return str.length() > position && c == str.charAt(position);
    }

    public static int totalLength(CharSequence ... strs) {
        int totalLength = 0;
        for (int i = 0; i < strs.length; ++i) {
            totalLength += null == strs[i] ? 0 : strs[i].length();
        }
        return totalLength;
    }

    public static String move(CharSequence str, int startInclude, int endExclude, int moveLength) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int len = str.length();
        if (Math.abs(moveLength) > len) {
            moveLength %= len;
        }
        StrBuilder strBuilder = StrBuilder.create(len);
        if (moveLength > 0) {
            int endAfterMove = Math.min(endExclude + moveLength, str.length());
            strBuilder.append(str.subSequence(0, startInclude)).append(str.subSequence(endExclude, endAfterMove)).append(str.subSequence(startInclude, endExclude)).append(str.subSequence(endAfterMove, str.length()));
        } else if (moveLength < 0) {
            int startAfterMove = Math.max(startInclude + moveLength, 0);
            strBuilder.append(str.subSequence(0, startAfterMove)).append(str.subSequence(startInclude, endExclude)).append(str.subSequence(startAfterMove, startInclude)).append(str.subSequence(endExclude, str.length()));
        } else {
            return StrUtil.str(str);
        }
        return strBuilder.toString();
    }

    public static String uuid() {
        return IdUtil.randomUUID();
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... strs) {
        StrBuilder sb = new StrBuilder();
        for (CharSequence str : strs) {
            sb.append(isNullToEmpty ? StrUtil.nullToEmpty(str) : str);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String swapCase(String str) {
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }
}

