/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.velocity;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.engine.velocity.SimpleStringResourceLoader;
import cn.hutool.extra.template.engine.velocity.VelocityTemplate;

public class VelocityEngine
implements TemplateEngine {
    private org.apache.velocity.app.VelocityEngine engine;

    public VelocityEngine() {
        this(new TemplateConfig());
    }

    public VelocityEngine(TemplateConfig config) {
        this(VelocityEngine.createEngine(config));
    }

    public VelocityEngine(org.apache.velocity.app.VelocityEngine engine) {
        this.engine = engine;
    }

    public org.apache.velocity.app.VelocityEngine getRowEngine() {
        return this.engine;
    }

    @Override
    public Template getTemplate(String resource) {
        return VelocityTemplate.wrap(this.engine.getTemplate(resource));
    }

    private static org.apache.velocity.app.VelocityEngine createEngine(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        org.apache.velocity.app.VelocityEngine ve = new org.apache.velocity.app.VelocityEngine();
        String charsetStr = config.getCharset().toString();
        ve.setProperty("input.encoding", (Object)charsetStr);
        ve.setProperty("output.encoding", (Object)charsetStr);
        ve.setProperty("file.resource.loader.cache", (Object)true);
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                ve.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                break;
            }
            case FILE: {
                String path = config.getPath();
                if (null == path) break;
                ve.setProperty("file.resource.loader.path", (Object)path);
                break;
            }
            case WEB_ROOT: {
                ve.setProperty("resource.loader", (Object)"webapp");
                ve.setProperty("webapp.resource.loader.class", (Object)"org.apache.velocity.tools.view.servlet.WebappLoader");
                ve.setProperty("webapp.resource.loader.path", (Object)StrUtil.nullToDefault(config.getPath(), "/"));
                break;
            }
            case STRING: {
                ve.setProperty("resource.loader", (Object)"str");
                ve.setProperty("str.resource.loader.class", (Object)SimpleStringResourceLoader.class.getName());
                break;
            }
        }
        ve.init();
        return ve;
    }
}

