/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectId {
    private static final AtomicInteger nextInc = new AtomicInteger(RandomUtil.randomInt());
    private static final int machine = ObjectId.getMachinePiece() | ObjectId.getProcessPiece();

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        int len = (s = StrUtil.removeAll((CharSequence)s, "-")).length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static byte[] nextBytes() {
        ByteBuffer bb = ByteBuffer.wrap(new byte[12]);
        bb.putInt((int)DateUtil.currentSeconds());
        bb.putInt(machine);
        bb.putInt(nextInc.getAndIncrement());
        return bb.array();
    }

    public static String next() {
        return ObjectId.next(false);
    }

    public static String next(boolean withHyphen) {
        byte[] array = ObjectId.nextBytes();
        StringBuilder buf = new StringBuilder(withHyphen ? 26 : 24);
        for (int i = 0; i < array.length; ++i) {
            int t;
            if (withHyphen && i % 4 == 0 && i != 0) {
                buf.append("-");
            }
            if ((t = array[i] & 0xFF) < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(t));
        }
        return buf.toString();
    }

    private static int getMachinePiece() {
        int machinePiece;
        try {
            StringBuilder netSb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                netSb.append(ni.toString());
            }
            machinePiece = netSb.toString().hashCode() << 16;
        }
        catch (Throwable e) {
            machinePiece = RandomUtil.randomInt() << 16;
        }
        return machinePiece;
    }

    private static int getProcessPiece() {
        int processId;
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            int atIndex = processName.indexOf(64);
            processId = atIndex > 0 ? Integer.parseInt(processName.substring(0, atIndex)) : processName.hashCode();
        }
        catch (Throwable t) {
            processId = RandomUtil.randomInt();
        }
        ClassLoader loader = ClassLoaderUtil.getClassLoader();
        int loaderId = loader != null ? System.identityHashCode(loader) : 0;
        StringBuilder processSb = new StringBuilder();
        processSb.append(Integer.toHexString(processId));
        processSb.append(Integer.toHexString(loaderId));
        int processPiece = processSb.toString().hashCode() & 0xFFFF;
        return processPiece;
    }
}

