/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron;

import cn.hutool.cron.Scheduler;
import cn.hutool.cron.TaskExecutor;
import cn.hutool.cron.task.Task;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TaskExecutorManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Scheduler scheduler;
    private final List<TaskExecutor> executors = new ArrayList<TaskExecutor>();

    public TaskExecutorManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public List<TaskExecutor> getExecutors() {
        return Collections.unmodifiableList(this.executors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutor spawnExecutor(Task task) {
        TaskExecutor executor = new TaskExecutor(this.scheduler, task);
        List<TaskExecutor> list = this.executors;
        synchronized (list) {
            this.executors.add(executor);
        }
        this.scheduler.threadExecutor.execute(executor);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutorManager notifyExecutorCompleted(TaskExecutor executor) {
        List<TaskExecutor> list = this.executors;
        synchronized (list) {
            this.executors.remove(executor);
        }
        return this;
    }

    @Deprecated
    public TaskExecutorManager destroy() {
        this.executors.clear();
        return this;
    }
}

