/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.ai;

import cn.hutool.ai.AIException;
import cn.hutool.ai.core.AIConfig;
import cn.hutool.ai.core.AIService;
import cn.hutool.ai.core.AIServiceProvider;
import cn.hutool.core.util.ServiceLoaderUtil;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class AIServiceFactory {
    private static final Map<String, AIServiceProvider> providers = new ConcurrentHashMap<String, AIServiceProvider>();

    public static AIService getAIService(AIConfig config) {
        return AIServiceFactory.getAIService(config, AIService.class);
    }

    public static <T extends AIService> T getAIService(AIConfig config, Class<T> clazz) {
        AIServiceProvider provider = providers.get(config.getModelName().toLowerCase());
        if (provider == null) {
            throw new IllegalArgumentException("Unsupported model: " + config.getModelName());
        }
        Object service = provider.create(config);
        if (!clazz.isInstance(service)) {
            throw new AIException("Model service is not of type: " + clazz.getSimpleName());
        }
        return service;
    }

    static {
        ServiceLoader<AIServiceProvider> loader = ServiceLoaderUtil.load(AIServiceProvider.class);
        for (AIServiceProvider provider : loader) {
            providers.put(provider.getServiceName().toLowerCase(), provider);
        }
    }
}

