/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.freemarker;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.extra.template.Engine;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.extra.template.engine.freemarker.FreemarkerTemplate;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.IOException;

public class FreemarkerEngine
implements Engine {
    Configuration cfg;

    public FreemarkerEngine() {
        this(new TemplateConfig());
    }

    public FreemarkerEngine(TemplateConfig config) {
        this(FreemarkerEngine.createCfg(config));
    }

    public FreemarkerEngine(Configuration freemarkerCfg) {
        this.cfg = freemarkerCfg;
    }

    @Override
    public String getName() {
        return "Freemarker";
    }

    @Override
    public Template getTemplate(String resource) {
        try {
            return FreemarkerTemplate.wrap(this.cfg.getTemplate(resource));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    private static Configuration createCfg(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setDefaultEncoding(config.getCharset().toString());
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(ClassUtil.getClassLoader(), config.getPath()));
                break;
            }
            case FILE: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file((String)config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new IORuntimeException((Throwable)e);
                }
            }
            case WEB_ROOT: {
                break;
            }
            case STRING: {
                cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader());
                break;
            }
        }
        return cfg;
    }
}

