/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.Converter;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.convert.impl.ArrayConverter;
import cn.hutool.core.convert.impl.BeanConverter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONBeanParser;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONDeserializer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JSONConverter
implements Converter<JSON> {
    protected static Object toArray(JSONArray jsonArray, Class<?> arrayClass) {
        return new ArrayConverter(arrayClass).convert((Object)jsonArray, null);
    }

    protected static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return Convert.toList(elementType, (Object)jsonArray);
    }

    protected static <T> T jsonConvert(Type targetType, Object value, JSONConfig jsonConfig) throws ConvertException {
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (targetType instanceof Class) {
            Class clazz = (Class)targetType;
            if (JSONBeanParser.class.isAssignableFrom(clazz)) {
                JSONBeanParser target = (JSONBeanParser)ReflectUtil.newInstanceIfPossible((Class)clazz);
                if (null == target) {
                    throw new ConvertException("Can not instance [{}]", new Object[]{targetType});
                }
                target.parse(value);
                return (T)target;
            }
            if (targetType == byte[].class && value instanceof CharSequence) {
                return (T)Base64.decode((CharSequence)((CharSequence)value));
            }
        }
        return JSONConverter.jsonToBean(targetType, value, jsonConfig.isIgnoreError());
    }

    protected static <T> T jsonToBean(Type targetType, Object value, boolean ignoreError) throws ConvertException {
        Object targetValue;
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (value instanceof JSON) {
            JSONDeserializer<?> deserializer = GlobalSerializeMapping.getDeserializer(targetType);
            if (null != deserializer) {
                return (T)deserializer.deserialize((JSON)value);
            }
            if (value instanceof JSONGetter && targetType instanceof Class && !Map.Entry.class.isAssignableFrom((Class)targetType) && BeanUtil.hasSetter((Class)((Class)targetType))) {
                JSONConfig config = ((JSONGetter)value).getConfig();
                BeanConverter converter = new BeanConverter(targetType, InternalJSONUtil.toCopyOptions(config).setIgnoreError(ignoreError).setFormatIfDate(config.getDateFormat()));
                return (T)converter.convertWithCheck(value, null, ignoreError);
            }
        }
        if (null == (targetValue = Convert.convertWithCheck((Type)targetType, (Object)value, null, (boolean)ignoreError)) && !ignoreError) {
            if (StrUtil.isBlankIfStr((Object)value)) {
                return null;
            }
            throw new ConvertException("Can not convert {} to type {}", new Object[]{value, ObjectUtil.defaultIfNull((Object)TypeUtil.getClass((Type)targetType), (Object)targetType)});
        }
        return (T)targetValue;
    }

    public JSON convert(Object value, JSON defaultValue) throws IllegalArgumentException {
        return JSONUtil.parse(value);
    }

    static {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        registry.putCustom(JSON.class, JSONConverter.class);
        registry.putCustom(JSONObject.class, JSONConverter.class);
        registry.putCustom(JSONArray.class, JSONConverter.class);
    }
}

