/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.context;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;
import org.shoulder.core.util.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class AppContext {
    private static final Logger log = LoggerFactory.getLogger(AppContext.class);
    private static final ThreadLocal<Map<String, String>> THREAD_LOCAL = ThreadLocal.withInitial(() -> new HashMap(9));

    public static String getUserId() {
        return AppContext.get("uid");
    }

    public static void setUserId(Object userId) {
        log.trace("setUserId ({})", userId);
        AppContext.set("uid", String.valueOf(userId));
    }

    public static void setUserId(String userId) {
        AppContext.set("uid", userId);
    }

    public static String getAccount() {
        return AppContext.get("account");
    }

    public static void setAccount(String account) {
        log.trace("setAccount ({})", account);
        AppContext.set("account", account);
    }

    public static String getName() {
        return AppContext.get("name");
    }

    public static void setName(String name) {
        log.trace("setName ({})", name);
        AppContext.set("name", name);
    }

    public static Locale getLocale() {
        return StringUtils.parseLocale(AppContext.get("locale"));
    }

    public static void setLocale(@NonNull Locale locale) {
        log.trace("set Locale ({})", locale);
        AppContext.set("locale", locale.toString());
    }

    public static String getToken() {
        return AppContext.get("Authentication");
    }

    public static void setToken(String token) {
        log.trace("setToken ({})", token);
        AppContext.set("Authentication", token);
    }

    public static String getTenantId() {
        return AppContext.get("tenant");
    }

    public static void setTenant(String tenantId) {
        log.trace("setTenant ({})", tenantId);
        AppContext.set("tenant", tenantId);
    }

    public static String getTranceId() {
        return AppContext.get("grayversion");
    }

    public static void setTranceId(String tranceId) {
        AppContext.set("grayversion", tranceId);
    }

    @Nullable
    public static String get(String key) {
        Map<String, String> map = THREAD_LOCAL.get();
        if (MapUtils.isNotEmpty(map)) {
            return null;
        }
        return map.get(key);
    }

    public static void set(String key, @Nullable String value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        Map<String, String> map = THREAD_LOCAL.get();
        if (map == null) {
            map = new HashMap<String, String>();
            THREAD_LOCAL.set(map);
        }
        map.put(key, value);
    }

    public static void clean() {
        THREAD_LOCAL.remove();
    }

    public static String remove(String key) {
        return THREAD_LOCAL.get() == null ? null : THREAD_LOCAL.get().remove(key);
    }

    public static void setAttributes(Map<String, String> contextMap) {
        THREAD_LOCAL.set(contextMap);
    }
}

