/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.context;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.TimeZone;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;
import org.shoulder.core.util.StringUtils;

public class AppInfo {
    private static final Logger log = LoggerFactory.getLogger(AppInfo.class);
    public static final String UTC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS Z";
    private static String appId = "";
    private static String errorCodePrefix = "";
    private static String version = "v1";
    private static boolean cluster = false;
    private static String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS Z";
    private static Charset charset = StandardCharsets.UTF_8;
    private static Locale defaultLocale = Locale.getDefault();
    private static TimeZone timeZone = TimeZone.getDefault();

    public static String appId() {
        return appId;
    }

    public static String errorCodePrefix() {
        return errorCodePrefix;
    }

    public static String version() {
        return version;
    }

    public static boolean cluster() {
        return cluster;
    }

    public static String dateFormat() {
        return dateFormat;
    }

    public static Charset charset() {
        return charset;
    }

    public static Locale defaultLocale() {
        return defaultLocale;
    }

    public static TimeZone timeZone() {
        return timeZone;
    }

    public static void initAppId(String appId) {
        AppInfo.appId = appId;
        log.info("initAppId: " + appId);
    }

    public static void initErrorCodePrefix(String errorCodePrefix) {
        AppInfo.errorCodePrefix = errorCodePrefix;
        log.info("initErrorCodePrefix: " + errorCodePrefix);
    }

    public static void initVersion(String version) {
        AppInfo.version = version;
        log.info("initVersion: " + version);
    }

    public static void initCluster(boolean cluster) {
        AppInfo.cluster = cluster;
        log.info("initCluster: " + cluster);
    }

    public static void initDateFormat(String dateFormat) {
        AppInfo.dateFormat = dateFormat;
        log.info("initDateFormat: " + dateFormat);
    }

    public static void initCharset(String charset) {
        AppInfo.charset = StringUtils.isNotEmpty((CharSequence)charset) && Charset.isSupported(charset) ? Charset.forName(charset) : StandardCharsets.UTF_8;
        log.info("initCharset: " + charset);
    }

    public static void initDefaultLocale(Locale locale) {
        defaultLocale = locale;
        log.info("initDefaultLocale: " + locale);
    }

    public static void initTimeZone(TimeZone timezone) {
        timeZone = timezone;
        log.info("initTimeZone: " + timezone);
    }
}

