/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.converter;

import java.time.format.DateTimeParseException;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;

public abstract class BaseDateConverter<T>
implements Converter<String, T> {
    private Map<String, String> formatMap = this.initTimeParserMap();

    protected abstract Map<String, String> initTimeParserMap();

    public T convert(@NonNull String source) {
        if (source.isEmpty()) {
            return null;
        }
        source = source.trim();
        for (Map.Entry<String, String> entry : this.formatMap.entrySet()) {
            if (!source.matches(entry.getValue())) continue;
            return this.parseDateOrTime(source, entry.getKey());
        }
        throw new IllegalArgumentException("invalid time format:'" + source + "'");
    }

    protected abstract T parseDateOrTime(@NonNull String var1, String var2) throws DateTimeParseException;
}

