/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.converter;

import java.time.format.DateTimeFormatter;
import java.util.function.BiFunction;
import org.shoulder.core.converter.BaseDateConverter;
import org.springframework.lang.NonNull;

public abstract class BaseLocalDateTimeConverter<T>
extends BaseDateConverter<T> {
    @Override
    protected T parseDateOrTime(@NonNull String sourceDateString, String dateTimeTemplate) {
        return this.parseFunction().apply(this.toStandFormat(sourceDateString), DateTimeFormatter.ofPattern(dateTimeTemplate));
    }

    @NonNull
    protected String toStandFormat(@NonNull String sourceDateString) {
        return sourceDateString;
    }

    protected abstract BiFunction<String, DateTimeFormatter, T> parseFunction();

    protected String toStandYearMonthDay(@NonNull String yyyyMMdd) {
        int stdFormatLength = 10;
        if (yyyyMMdd.length() == 10) {
            return yyyyMMdd;
        }
        String split = yyyyMMdd.contains("-") ? "-" : "/";
        String[] timePart = yyyyMMdd.split(split);
        assert (timePart.length == 3);
        String year = timePart[0];
        String month = timePart[1];
        String day = timePart[2];
        StringBuilder stdDateFormat = new StringBuilder(year);
        stdDateFormat.append(split);
        if (month.length() == 1) {
            stdDateFormat.append("0");
        }
        stdDateFormat.append(month);
        stdDateFormat.append(split);
        if (day.length() == 1) {
            stdDateFormat.append("0");
        }
        stdDateFormat.append(day);
        return stdDateFormat.toString();
    }
}

