/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.converter;

import java.text.ParseException;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.shoulder.core.converter.BaseDateConverter;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;
import org.springframework.lang.NonNull;

public class DateConverter
extends BaseDateConverter<Date> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean lenientMode = false;

    @Override
    protected Map<String, String> initTimeParserMap() {
        LinkedHashMap<String, String> formatMap = new LinkedHashMap<String, String>(11);
        formatMap.put("yyyy", "^\\d{4}");
        formatMap.put("yyyy-MM", "^\\d{4}-\\d{1,2}$");
        formatMap.put("yyyy-MM-dd", "^\\d{4}-\\d{1,2}-\\d{1,2}$");
        formatMap.put("yyyy-MM-dd HH", "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}");
        formatMap.put("yyyy-MM-dd HH:mm", "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$");
        formatMap.put("yyyy-MM-dd HH:mm:ss", "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$");
        formatMap.put("yyyy-MM-dd'T'HH:mm:ss.SSS Z", "^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}");
        formatMap.put("yyyy/MM", "^\\d{4}/\\d{1,2}$");
        formatMap.put("yyyy/MM/dd", "^\\d{4}/\\d{1,2}/\\d{1,2}$");
        formatMap.put("yyyy/MM/dd HH", "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}");
        formatMap.put("yyyy/MM/dd HH:mm", "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}$");
        formatMap.put("yyyy/MM/dd HH:mm:ss", "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$");
        return formatMap;
    }

    @Override
    protected Date parseDateOrTime(@NonNull String sourceDateString, String dateTimeTemplate) {
        try {
            return FastDateFormat.getInstance((String)dateTimeTemplate).parse(sourceDateString);
        }
        catch (ParseException e) {
            this.log.info("dateFormatError, date={}, format={}", new Object[]{sourceDateString, dateTimeTemplate, e});
            throw new DateTimeParseException("Text '" + sourceDateString + "' could not be parsed: " + e.getMessage(), sourceDateString, 0, e);
        }
    }
}

