/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.converter;

import org.shoulder.core.converter.EnumMissMatchHandler;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;

public class EnumConverter
implements Converter<String, Enum> {
    private Class<? extends Enum> enumType;
    private EnumMissMatchHandler missMatchHandler;

    public EnumConverter(@NonNull Class<? extends Enum> enumType, EnumMissMatchHandler missMatchHandler) {
        this.enumType = enumType;
        this.missMatchHandler = missMatchHandler;
    }

    public Enum convert(@NonNull String source) {
        Enum[] enums;
        if (source.isBlank()) {
            return (Enum)this.missMatchHandler.handleNullSource(this.enumType);
        }
        for (Enum e : enums = this.enumType.getEnumConstants()) {
            if (!e.name().equals(source)) continue;
            return e;
        }
        return (Enum)this.missMatchHandler.handleMissMatch(this.enumType, source);
    }
}

