/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.converter;

import cn.hutool.core.util.ReflectUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;
import org.shoulder.core.util.StringUtils;

public class EnumDeserializer
extends StdDeserializer<Enum<?>> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String stringToEnumMethodName;
    private final String indexFieldName;

    public EnumDeserializer() {
        this(null, null);
    }

    public EnumDeserializer(String stringToEnumMethodName, String indexFieldName) {
        super(Enum.class);
        String defaultStringToEnumMethodName = "from";
        String defaultIndexFieldName = "code";
        this.stringToEnumMethodName = StringUtils.isEmpty((CharSequence)stringToEnumMethodName) ? defaultStringToEnumMethodName : stringToEnumMethodName;
        this.indexFieldName = StringUtils.isEmpty((CharSequence)stringToEnumMethodName) ? defaultIndexFieldName : indexFieldName;
    }

    public Enum<?> deserialize(JsonParser p, DeserializationContext context) throws IOException {
        JsonToken token = p.getCurrentToken();
        String value = null;
        while (!token.isStructEnd()) {
            if (this.indexFieldName.equals(p.getText())) {
                p.nextToken();
                value = p.getValueAsString();
            } else {
                p.nextToken();
            }
            token = p.getCurrentToken();
        }
        if (value == null || "".equals(value)) {
            return null;
        }
        Object obj = p.getCurrentValue();
        if (obj == null) {
            return null;
        }
        Field field = ReflectUtil.getField(obj.getClass(), (String)p.getCurrentName());
        if (field == null) {
            return null;
        }
        Class<?> fieldType = field.getType();
        try {
            Method method = fieldType.getMethod(this.stringToEnumMethodName, String.class);
            return (Enum)method.invoke(null, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.log.warn("Deserialize enum fail! Can't invoke the method named  '" + this.stringToEnumMethodName + "'", e);
            return null;
        }
    }
}

